<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div class="wrapper">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage sandstonedental
 * @since 1.0
 * @version sandstonedental 1.0
 */
?>
 <!DOCTYPE html>
    <html <?php language_attributes(); ?> class="no-js no-svg">
    <head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="theme-color" content="#023c5b" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.0.0/animate.min.css"/>
    <title><?php wp_title( '|', true, 'right' ); ?></title>
    <link rel="profile" href="https://gmpg.org/xfn/11">    
    <?php wp_head(); ?>
    </head>
<body <?php body_class(); ?>>

<div class="wrapper">

<div class="header_top">

        <div class="container">
        
            <?php echo get_field('top_header_text' , 'options' ); ?>

        </div>

</div> <!-- Header Top --->


<div class="header_stick" id="myHeader">

<div class="header_main">

        <div class="container-fluid">

                <div class="col-xs-12 col-sm-12 col-md-5 logo">

                        <?php echo do_shortcode('[logo]'); ?>

                </div> <!-- Logo -->

                <div class="col-xs-12 col-sm-12 col-md-6 text-right">

                    <div class="col-xs-12 col-sm-4 col-md-4 top_phone">

                        <a href="tel:4032753131">
                            <i class="fa fa-phone" aria-hidden="true"></i>
                            <?php echo get_field('call_now_text' ,'options' ); ?>
                        </a>

                    </div> <!-- Phone Number-->

                    <div class="col-xs-12 col-sm-4 col-md-5 book_now">

                        <?php echo get_field('book_now' , 'options' ); ?>

                    </div> <!-- Book Now-->

                    <div class="col-xs-12 col-sm-4 col-md-2 social_icon">

                        <?php echo do_shortcode('[social_icons]'); ?>

                    </div><!-- Social Icon-->

                </div>
        
        </div>

</div> <!-- Header Main -->

<div class="main_menu">

    <div class="container">

        <div class="col-xs-12 col-sm-12 col-md-12">
                        
                <ul class="nav navbar-nav header-nav">
                    <?php
                        wp_nav_menu(array(
                        'walker' => new CPM_Nav_Walker,
                        'theme_location' => 'primary_navigation',
                        'make_select' => false,
                        'class' => 'primary-nav',
                        'items_wrap' => '%3$s'
                        )); 
                    ?>
                </ul>
                
            </div> <!-- Menu section -->

    </div>

</div><!-- Menu -->

</div>

<?php if(is_front_page()) {  ?>

<div class="slider_main">

    <div class="slider_text text-center">

        <?php layerslider(1) ?>         

    </div> <!-- Slider Section -->                
  
</div> <!-- Banner Inner --->

    <div class="scroll_to">
    
            <a href="#">
                <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/down-arrow-icon.png"  alt="down_img" class="img-responsive"/>
            </a>

    </div>

<?php } else {

    global $post; 

    if (has_post_thumbnail( $post->ID ) ){
        $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));
    } else {
        $image = get_field('inner_header_image' , 'options' ); 
    }
    ?>

     <div class="banner_inner" style="background: linear-gradient(180deg,rgba(0,0,0,0),rgba(0,0,0,0)), url(<?php echo $image; ?>) center;"> 

        <div class="inner_header_text text-center">

            <div class="container">

                    <?php echo the_field("fancy_title",$post->ID );?>

            </div>           

        </div> <!-- Slider Section --> 

</div>

<?php } ?>

 
