<?php

require_once('inc/shortcode.php'); 

/*
 Theme CSS & JS
*/

function child_theme_enqueue_styles() 
{
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/assets/css/main.css', array( 'main', 'bootstrap','cpm' ));
    wp_enqueue_style( 'child-responsive', get_stylesheet_directory_uri() . '/assets/css/responsive.css', array( 'main', 'bootstrap', 'child-style', 'responsive','cpm' ));

    if (!is_admin()) { wp_deregister_script('jquery'); wp_register_script('jquery', 'https://ajax.googleapis.com/ajax/libs/jquery/2.2.1/jquery.min.js'); }

     //Slick CSS
     wp_enqueue_style( 'slick-min', get_stylesheet_directory_uri() . '/assets/css/slick.css');

     //Slick Theme CSS
     wp_enqueue_style( 'slick-theme-css', get_stylesheet_directory_uri() . '/assets/css/slick-theme-min.css');

     //Slick JS
     wp_register_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js','','1.1', true);
    wp_enqueue_script('slick-js');


    wp_enqueue_script( 'child-scripts', get_stylesheet_directory_uri() . '/assets/js/main.js', array(), null, true);

    if (function_exists('cpm_compile_less')) {
        cpm_compile_less(
            array(
                '/assets/less/main.less' => '/assets/css/main.css',
                '/assets/less/responsive.less' => '/assets/css/responsive.css'
            ),
            dirname(__FILE__)
        );
    }
}
add_action( 'wp_enqueue_scripts', 'child_theme_enqueue_styles' );

/**
 *
 *  Page Title 
 */

function sandstonedental_wp_title( $title, $sep ) 
{

    global $paged, $page;

    if ( is_feed() )
        return $title;

    // Add the site name.
    $title .= get_bloginfo( 'name' );

    // Add the site description for the home/front page.
    $site_description = get_bloginfo( 'description', 'display' );
    if ( $site_description && ( is_home() || is_front_page() ) )
        $title = "$title $sep $site_description";

    // Add a page number if necessary.
    if ( $paged >= 2 || $page >= 2 )
        $title = "$title $sep " . sprintf( __( 'Page %s', 'sandstonedental' ), max( $paged, $page ) );

    return $title;
    
}

add_filter( 'wp_title', 'sandstonedental_wp_title', 10, 2 );


/**
 * Register New Menus
*/

function wpb_custom_new_menu() 
 {

    //Quick Links
    register_nav_menu('my-custom-footer-menu',__( 'Footer Main Menu' ));
}

add_action( 'init', 'wpb_custom_new_menu' );


/**
 * 
 * CPT Reviews
 */

function setup_reviews()
{ 
    register_post_type(

        'Dentist Slider', array(
        'label' => __('Dentist Slider'),
        'supports' => array( 'title', 'thumbnail', 'revisions' ),
        'show_ui' => true,
    ));

    register_post_type(
         
        'Reveiws', array(
        'label' => __('Reviews'),
        'supports' => array( 'title', 'editor', 'thumbnail', 'revisions' ),
        'show_ui' => true,
    ));
}

add_action('init', 'setup_reviews');


/**
 * Team CPT
 */

add_action( 'init', 'markets_custom_post_type_func' );

function markets_custom_post_type_func() 
{
    //posttypename = teams
    $labels = array(
    'name' => _x( 'Teams', 'teams' ),
    'singular_name' => _x( 'Teams', 'teams' ),
    'add_new' => _x( 'Add New', 'teams' ),
    'add_new_item' => _x( 'Add New teams', 'teams' ),
    'edit_item' => _x( 'Edit teams', 'teams' ),
    'new_item' => _x( 'New teams', 'teams' ),
    'view_item' => _x( 'View teams', 'teams' ),
    'search_items' => _x( 'Search teams', 'teams' ),
    'not_found' => _x( 'No services found', 'teams' ),
    'not_found_in_trash' => _x( 'No services found in Trash', 'teams' ),
    'parent_item_colon' => _x( 'Parent teams:', 'teams' ),
    'menu_name' => _x( 'Teams', 'teams' ),
    );
    $args = array(
    'labels' => $labels,
    'hierarchical' => true,
    'description' => 'Hi, this is my custom post type.',
    'supports' => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'trackbacks', 'custom-fields', 'comments', 'revisions', 'page-attributes' ),
    'taxonomies' => array(  ),
    'public' => true,
    'show_ui' => true,
    'show_in_menu' => true,
    'show_in_nav_menus' => true,
    'publicly_queryable' => true,
    'exclude_from_search' => false,
    'has_archive' => false,
    'query_var' => true,
    'can_export' => true,
    'rewrite' => array( 'slug' => 'meet-our-team',  'with_front' => false ),
    'capability_type' => 'post'
    );

    register_post_type( 'teams', $args );
}

add_image_size( 'Team_image', 350, 550, true );

add_shortcode( 'meet_our_team', 'meet_our_team_cb' );

function meet_our_team_cb( $atts ) {

    $atts = shortcode_atts( array(
        'team_type' => '',
        'team_title' => '',
        'col'   => 4,
    ), $atts, 'meet_our_team' );

    $columns = !empty($atts['col']) ? $atts['col'] : 3;

    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

    $team_args = array(
        'post_type'=> 'teams',
        'posts_per_page' => -1,
        'paged' => $paged,
        'orderby' => 'menu_order',
        'fields' => 'ids'
    );

    if(!empty($atts['team_type'])) {

        $team_args['meta_query'] = array(
            'relation' => 'AND',
            array(
                'key' => 'team_type',
                'value' => $atts['team_type'],
                'compare' => 'LIKE',
            )
        );
    }

    $team_members = get_posts($team_args);

    ob_start();
    ?>
    <div class="meet-our-team-box">

        <div class="row">

            <?php if( !empty($atts['team_title']) && !empty($team_members)) { ?>

                <div class="col-md-12 text-center">
                    <h2 class="our-team-title" style="margin: 30px 0;"><?php echo $atts['team_title']; ?></h2>
                </div>

            <?php } ?>

            <?php
            if(!empty($team_members) && is_array($team_members)) {

                foreach ($team_members as $team_member ) {

                    if(get_field('team_popup_content',$team_member)) { ?>

                        <div class="col-xs-12 col-sm-<?php echo $columns; ?> col-md-<?php echo $columns; ?> text-center">
                            <div class="team_boxs effect-jazz">
                                <a class="therapist-card" data-toggle="modal" href="#team_popup<?php echo $team_member; ?>">
                                    <div class="therapist-card__therapist-avatar">
                                        <?php
                                        $thumbnail_id = get_post_thumbnail_id( $team_member );
                                        $alt = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true);
                                        echo get_the_post_thumbnail($team_member,'Team_image', array('class' => 'img-responsive' ,'alt' => $alt ,'title' => get_the_title($team_member) ));
                                        ?>
                                    </div>
                                    <div class="therapist-card__details-container">
                                        <div class="therapist-card__detail">
                                            <h3 class="therapist-card__title availIn24Hrs"><?php echo get_the_title($team_member);?></h3>
                                            <p class="therapist-card__disciplines"><?php echo get_field('type_of_services', $team_member); ?></p>
                                            <p class="link_bio">Click to Meet <?php echo get_the_title($team_member);?></p>
                                        </div>
                                    </div>
                                </a>
                                <div id="team_popup<?php echo $team_member; ?>" class="modal fade" role="dialog">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                <div class="modal-title">
                                                    <?php echo get_the_title($team_member); ?>
                                                    <h4><?php echo get_field('type_of_services', $team_member); ?></h4>
                                                </div>
                                            </div>
                                            <div class="modal-body"><?php echo get_field("team_popup_content", $team_member); ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    <?php } else { ?>

                        <div class="col-xs-12 col-sm-<?php echo $columns; ?> col-md-<?php echo $columns; ?> text-center">
                            <div class="team_boxs effect-jazz">
                                <a href="<?php echo get_the_permalink($team_member); ?>" class="therapist-card">
                                    <div class="therapist-card__therapist-avatar">
                                        <?php
                                        $thumbnail_id = get_post_thumbnail_id( $team_member );
                                        $alt = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true);
                                        echo get_the_post_thumbnail($team_member,'Team_image', array('class' => 'img-responsive' ,'alt' => $alt , 'title' => get_the_title($team_member) ));
                                        ?>
                                    </div>
                                    <div class="therapist-card__details-container">
                                        <div class="therapist-card__detail">
                                            <h3 class="therapist-card__title availIn24Hrs"><?php echo get_the_title($team_member); ?></h3>
                                            <p class="therapist-card__disciplines"><?php echo get_field('type_of_services',$team_member); ?></p>
                                            <h4 class="view_more_btn_new">View Profile</h4>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>

                    <?php }
                }
            }
            ?>

        </div>

    </div>
    <?php
    $team_html = ob_get_clean();

    return $team_html;
}



add_filter('locale', 'my_get_locale');

function my_get_locale($locale) 
{
    return "en-CA";
}  
add_action('wp_footer', 'open_external_links_in_newtab');
function open_external_links_in_newtab(){
?>
<script type="text/javascript">
(function($) {
  var domainUrl = window.location.origin;
  $('a').not('a[href*="'+ domainUrl +'"], a[href*="mailto:"], a[href*="tel:"], a[href*="javascript:;"] ').attr({
    'target':'_blank',
    'rel': 'nofollow noreferrer',
  })
})(jQuery);
</script>
<?php
}
add_action('wp_head', function() {
    ?>
    <link rel="preload" as="style" data-no-minify="1" href="<?php echo site_url(); ?>/wp-content/plugins/LayerSlider2/static/skins/v5/skin.css" />
    <?php
  });