<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after
 *
 * @package WordPress
 * @subpackage Sandstone Dental
 * @since Sandstone Dental 1.0
 */
?>

  <div class="book_online_section">

      <div class="container">

          <div class="col-xs-12 col-md-12 col-sm-12 text-center">

              <?php echo the_field('book_online_now_text','option'); ?>
              <?php echo do_shortcode('[contact-form-7 id="243" title="Book Online Now"]'); ?>

          </div>

      </div>

  </div> <!-- Book Online Now -->

  
  <div class="cta_section">

    <div class="container" >

        <div class="col-xs-12 col-sm-12 col-md-12 text-center animate__animated animate__fadeInUp">

            <?php echo the_field('call_to_action_text','option'); ?>

        </div>

    </div>

  </div> <!-- CTA --> 

  <div class="cta_secondary">
  
    <div class="container-fluid">

        <div class="col-xs-12 col-sm-12 col-md-12 text-center animate__animated animate__fadeInUp">

            <?php echo the_field('footer_text','option'); ?>

        </div>

    </div>

  </div> <!-- CTA Second --->

  <div class="footer">

      <div class="container">

            <div class="col-xs-12 col-sm-12 col-md-12 text-center footer_menu">

              <ul class="footer-quick-nav">

                    <?php

                      wp_nav_menu(array(
                        'walker' => new CPM_Nav_Walker,
                        'theme_location' => 'footer_navigation',
                        'make_select' => false,
                        'class' => 'footer-copy-nav',
                        'items_wrap' => '%3$s'
                      ));

                    ?>

                </ul>

            </div> <!-- Footer Menu --->

            <div class="col-xs-12 col-sm-12 col-md-12 text-center footer_logo">
            
                <a href="<?php echo get_site_url();?>">

                  <img src="<?php echo the_field('footer_logo','option');?>"  alt="footer_logo">
                  
                </a>

            </div> <!-- Footer Logo --->

            <div class="col-xs-12 col-sm-12 col-md-12 text-center social_icons">
            
                <?php echo do_shortcode('[social_icons]'); ?>

            </div> <!-- Social Icons --->

            <div class="col-xs-12 col-sm-12 col-md-12 text-center">

                <div class="footer_disclaimer">

                <?php echo the_field('footer_disclaimer','option'); ?>                        

                </div>
                
            </div> <!-- Disclaimer -->

      </div>

  </div> <!-- Footer Main --->

  <div class="footer_bottom">

<?php $footer_copy = get_field('footer_copy', 'options'); ?>
<?php $footer_maker = get_field('footer_maker', 'options'); ?>

<div class="footer-copy-maker">

  <div class="container"> 

      <div class="col-xs-12 col-lg-8 col-md-8 col-sm-12 left">

            <div class="copy_right">

              <?php echo do_shortcode($footer_copy); ?>
                        
            </div>   
                    
        </div>
                
          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 text-right right desing_by">
                      
              <?php echo $footer_maker; ?>
                  
          </div>
                
      </div>            
         
  </div>

</div> <!-- Footer Bottom -->

</div> <!-- Wrapper --->
       
<?php wp_footer(); ?>

<script>
window.onscroll = function() {myFunction()};

var header = document.getElementById("myHeader");
var sticky = header.offsetTop;

function myFunction() {
  if (window.pageYOffset > sticky) {
    header.classList.add("sticky");
  } else {
    header.classList.remove("sticky");
  }
}
</script>
</body>
</html>