<?php

wp_enqueue_script('hpl_slider',get_site_url().'/wp-content/plugins/hcube-library/js/slider.js',array('jquery') );

add_shortcode( 'hpl_slider', 'hpl_sliderpreload' );
function hpl_sliderpreload( $atts ){
	$a = shortcode_atts( array('height' => '','width' => '','class' => '','images' => '','timer' => ''), $atts );
	
	$images = '';
	$ids = explode(',',$a['images']);
	for($i = 0 ; $i < count($ids) ; $i++){
		if($i)$images .= ',';
		$images .= wp_get_attachment_image_src(explode(',',$a['images'])[$i], 'full')[0];
	}
	
	return "
			<div class='hpl_slider hpl_animation hpl_slider_component ".$a['class']."' 
				data-current='0' 
				data-total='".count(explode(',',$images))."' 
				data-preloading='false' 
				data-timer='".$a['timer']."' 
				style='height:".$a['height'].";width:".$a['width'].";'
				data-images='".$images."' 
			>
				<div class='hpl_slider_preload hpl_slider_component' data-next='0'></div>
				<div class='hpl_slider_background hpl_slider_component'
					style='
						transition: background-image 1s cubic-bezier(1, -0.35, 0.58, 1);
						height:100%;
						width:100%;
						background-image:url(".explode(',',$images)[0].");
						background-size: contain;
						background-position: center;
						background-repeat: no-repeat;
					'
				></div>
				<div class='hpl_slider_internal_a hpl_slider_component'></div>
				<div class='hpl_slider_internal_b hpl_slider_component'></div>
				<div class='hpl_slider_internal_c hpl_slider_component'></div>
			</div>" ;
	
}

add_action( 'fusion_builder_before_init', 'hpl_slider_fusionelement' );
function hpl_slider_fusionelement() {
	fusion_builder_map( array('name'=> esc_attr__( 'H-cube Slider', 'fusion-builder' ),
			'shortcode'=> 'hpl_slider','icon'=> 'fusiona-images','allow_generator' => true,
			'params'=> array(
				array('heading'     => esc_attr__( 'Gallery Images', 'fusion-builder' ),
				    'param_name'  	=> 'images','type'=> 'upload_images','value'=> '',),
				array('heading'		=> esc_attr__( 'Seconds between transitions', 'fusion-builder' ),
					'param_name'	=> 'timer','type'=> 'range','value'=> '10','min'=> '3','max'=> '20','step'=> '.1',),		
				array('heading'		=> esc_attr__( 'Height', 'fusion-builder' ),'value'=> '350px',
					'param_name'  	=> 'height','type'=> 'textfield',),
				array('heading'		=> esc_attr__( 'Width', 'fusion-builder' ),'value'=> '100%',
					'param_name'  	=> 'width','type'=> 'textfield',),
				array('heading'		=> esc_attr__( 'Custom Class Names', 'fusion-builder' ),
					'param_name'  	=> 'class','type'=> 'textfield',),
			)));}