<?php


if ( !is_admin() )add_action( 'wp_enqueue_scripts', 'hpl_enqueue_custom_css', 100 );
function hpl_enqueue_custom_css(){
	global $post;
	if(!file_exists( realpath(__DIR__).'/customcss/global.css')){
		$fp = fopen( realpath(__DIR__).'/customcss/global.css', "w");
		if($fp) {
			fwrite ( $fp , str_replace("\\", "",get_option('hpl_global_stylesheet')) );
			fclose ($fp);
		}
	}

	if(!file_exists( realpath(__DIR__).'/customcss/post' . $post->ID . '.css')){
		$fp = fopen( realpath(__DIR__).'/customcss/post' . $post->ID . '.css', "w");
		if($fp) {
			fwrite ( $fp , str_replace("\\", "",get_post_meta($post->ID,'_hpl_meta_key',true)) );
			fclose ($fp);
		}
	}
	wp_enqueue_style( 'hpl_globalcss', get_site_url().'/wp-content/plugins/hcube-library/php/customcss/global.css');
	wp_enqueue_style( 'hpl_pagecss',get_site_url().'/wp-content/plugins/hcube-library/php/customcss/post' . $post->ID . ".css");
}

if ( is_admin() ){

	
	add_action('add_meta_boxes', 'hpl_add_custom_box');
	function hpl_add_custom_box(){
		$screens = ['post', 'page'];
		foreach ($screens as $screen) {
			add_meta_box(
				'hpl_box_id',
				'Custom Styles',
				'hpl_custom_box_html',
				$screen,
				'normal',
				'high'
			);}}
			
	function hpl_custom_box_html($post){
		?>
<textarea style="min-height:50px;width:100%;" class="form-control" id="hpl_field" name="hpl_field" ><?php echo get_post_meta($post->ID,"_hpl_meta_key", true ); ?></textarea>
		<?php
	}

	add_action('save_post', 'hpl_save_postdata');
	function hpl_save_postdata($post_id)
	{
		if (array_key_exists('hpl_field', $_POST)) {
			update_post_meta(
				$post_id,
				'_hpl_meta_key',
				$_POST['hpl_field']
			);
		}
		$fp = fopen( realpath(__DIR__).'/customcss/post' . $post_id . ".css", "w");
		if($fp) {
			fwrite ( $fp , str_replace("\\", "", $_POST['hpl_field']) );
			fclose ($fp);
		}
	}
}