	var map;
	var mapContainer;
	var markers = [];
	var infoWindow;
	var locationSelect;
	var locationDetails = 1;
	var realloc;
	var gpscheck = false;
	var mapping;
    function initMap() {
		mapContainer = document.getElementById("map");
		
		
		var arr = mapContainer.dataset.colors.split(',');
		console.log(arr);
		var colors = [];
		for( var i = 0 ; i < arr.length ; i ++ ){
			if(arr[i].split(':')[1]=='geometry'){colors[0]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='labels.text.stroke'){colors[1]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='labels.text.fill'){colors[2]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='administrative.locality+labels.text.fill'){colors[3]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='poi+labels.text.fill'){colors[4]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='poi.park+geometry'){colors[5]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='poi.park+labels.text.fill'){colors[6]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='road+geometry'){colors[7]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='road+geometry.stroke'){colors[8]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='road+labels.text.fill'){colors[9]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='road.highway+geometry'){colors[10]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='road.highway+geometry.stroke'){colors[11]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='road.highway+labels.text.fill'){colors[12]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='transit+geometry'){colors[13]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='transit.station+labels.text.fill'){colors[14]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='water+geometry'){colors[15]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='water+labels.text.fill'){colors[16]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
			if(arr[i].split(':')[1]=='water+labels.text.stroke'){colors[17]=arr[i].split(':')[0].replace(/[\n\r]+/g, '');}
		}
		console.log(colors);
		var initcor;
		var initrad;
		if(mapContainer.dataset.initloc){
			initcor = {lat: parseInt(mapContainer.dataset.initlat,10), lng: parseInt(mapContainer.dataset.initlng,10)};
			initrad = mapContainer.dataset.initrad;
		}else{
			initcor = {lat: 0, lng: 0};
			initrad = 1000000;
		}
        map = new google.maps.Map(mapContainer, {
            center: initcor,zoom: 11,styles: [
            {elementType: 'geometry', stylers: [{color: colors[0]}]},
            {elementType: 'labels.text.stroke', stylers: [{color: colors[1]}]},
            {elementType: 'labels.text.fill', stylers: [{color: colors[2]}]},
            {featureType: 'administrative.locality',elementType: 'labels.text.fill',stylers: [{color: colors[3]}]},
            {featureType: 'poi',elementType: 'labels.text.fill',stylers: [{color: colors[4]}]},
            {featureType: 'poi.park',elementType: 'geometry',stylers: [{color: colors[5]}]},
            {featureType: 'poi.park',elementType: 'labels.text.fill',stylers: [{color: colors[6]}]},
            {featureType: 'road',elementType: 'geometry',stylers: [{color: colors[7]}]},
            {featureType: 'road',elementType: 'geometry.stroke',stylers: [{color: colors[8]}]},
            {featureType: 'road',elementType: 'labels.text.fill',stylers: [{color: colors[9]}]},
            {featureType: 'road.highway',elementType: 'geometry',stylers: [{color: colors[10]}]},
            {featureType: 'road.highway',elementType: 'geometry.stroke',stylers: [{color: colors[11]}]},
            {featureType: 'road.highway',elementType: 'labels.text.fill',stylers: [{color: colors[12]}]},
            {featureType: 'transit',elementType: 'geometry',stylers: [{color: colors[13]}]},
            {featureType: 'transit.station',elementType: 'labels.text.fill',stylers: [{color: colors[14]}]},
            {featureType: 'water',elementType: 'geometry',stylers: [{color: colors[15]}]},
            {featureType: 'water',elementType: 'labels.text.fill',stylers: [{color: colors[16]}]},
            {featureType: 'water',elementType: 'labels.text.stroke',stylers: [{color: colors[17]}]
            }
          ],
            mapTypeId: "roadmap",
            mapTypeControlOptions: {style: google.maps.MapTypeControlStyle.DROPDOWN_MENU}});
		autocomplete = new google.maps.places.Autocomplete(document.getElementById('addressInput'));
        infoWindow = new google.maps.InfoWindow();
		if(mapContainer.dataset.details=='off')locationDetails = 0;
		if(locationDetails)locationSelect = document.getElementById("locationSelect");
		searchLocationsNear(initcor,initrad,1,0);
		
		if(mapContainer.dataset.gps=='page'||mapContainer.dataset.gps=='results')hpl_gpssearch(2000);
	}
	
	function hpl_gpssearch(delay){
		if(mapContainer.dataset.gpson=='yes'){
				//console.log('gps');
			navigator.geolocation.getCurrentPosition(function(position){
				realloc = {lat: position.coords.latitude , lng: position.coords.longitude};
				var initrad = mapContainer.dataset.radius;
				//console.log(gpscheck)
				//console.log('gpsrun');
				if(!mapping)delay=0;
				setTimeout(function(){searchLocationsNear(realloc,initrad,1,1);},delay);
			});
		}
	}
	
	function fitToMarkers() {
		var bounds = new google.maps.LatLngBounds();
		for( var index in markers ) {
			var latlng = markers[index].getPosition();
			bounds.extend(latlng);
		}
		if (bounds.getNorthEast().equals(bounds.getSouthWest())) {
		   var extendPoint1 = new google.maps.LatLng(bounds.getNorthEast().lat() + 0.01, bounds.getNorthEast().lng() + 0.01);
		   var extendPoint2 = new google.maps.LatLng(bounds.getNorthEast().lat() - 0.01, bounds.getNorthEast().lng() - 0.01);
		   bounds.extend(extendPoint1);
		   bounds.extend(extendPoint2);
		}
		map.fitBounds(bounds);
	}
		
	function changeLocation(ele) {
		//console.log('changeLocation: '+ele);
            var markerNum = ele.dataset.num;
            if (markerNum != "none"){google.maps.event.trigger(markers[markerNum], "click");}};
		  
    function searchLocations(event,address,radius) {
		//console.log('searchLocations');
		
		 if(event)event.preventDefault();
		 if(address==0)address = document.getElementById("addressInput").value;	
         var geocoder = new google.maps.Geocoder();
         geocoder.geocode({address: address}, function(results, status) {
           if (status == google.maps.GeocoderStatus.OK) {
            searchLocationsNear(results[0].geometry.location,radius,0,0);
           } else {alert(address + " not found");}});}

    function clearLocations() {
		//console.log('clearLocations');
         infoWindow.close();
         for (var i = 0; i < markers.length; i++) {markers[i].setMap(null);}
         markers.length = 0;
         if(locationDetails){
			locationSelect.innerHTML = "";
			var div = document.createElement("div");
			locationSelect.appendChild(div);}}

    function searchLocationsNear(center,radius,coorsonly,gps) {
		mapping=true;
		//console.log(center);
		if(document.getElementById("radiusSelect")){
			if(!radius)radius = document.getElementById("radiusSelect").value;
		}else{
			if(!radius)radius = mapContainer.dataset.radius;
		}
		var lat;if(!coorsonly){ lat = center.lat(); }else{ lat = center.lat; }
		var lng;if(!coorsonly){ lng = center.lng(); }else{ lng = center.lng; }
		//console.log("../../wp-content/plugins/hcube-library/php/func_gmap_xmlgen.php?lat=" + lat + "&lng=" + lng + "&radius=" + (radius*(mapContainer.dataset.unit=='km'?0.621371:1)));
        var searchUrl = "../../wp-content/plugins/hcube-library/php/func_gmap_xmlgen.php?lat=" + lat + "&lng=" + lng + "&radius=" + (radius*(mapContainer.dataset.unit=='km'?0.621371:1));
        downloadUrl(searchUrl, function(data) {
			var xml = parseXml(data);
			var listing = mapContainer.dataset.listing;
			if(listing=='yes')var list = mapContainer.dataset.list.split(',');
			var markerNodes = xml.documentElement.getElementsByTagName("marker");
			var bounds = new google.maps.LatLngBounds();
			var maxnum = 500;
			if(mapContainer.dataset.maxnum && !coorsonly)maxnum = mapContainer.dataset.maxnum;
			//console.log(Math.min(markerNodes.length,maxnum ));
			if(Math.min(markerNodes.length,maxnum )){
				clearLocations();
				//console.log(0);
				for (var i = 0; i < Math.min(markerNodes.length,maxnum ); i++) {
					var id = markerNodes[i].getAttribute("id");
					if(listing=='no' || list.includes(id)){
					var name = markerNodes[i].getAttribute("name");
					var address = markerNodes[i].getAttribute("address");
					var distance = parseFloat(markerNodes[i].getAttribute("distance"));
					var latlng = new google.maps.LatLng(    parseFloat(markerNodes[i].getAttribute("lat")),    parseFloat(markerNodes[i].getAttribute("lng")));
					var hours = markerNodes[i].getAttribute("hours");
					var phone = markerNodes[i].getAttribute("phone");
					var link = markerNodes[i].getAttribute("link");
					var thumbnail = markerNodes[i].getAttribute("thumbnail");
					if(locationDetails)createOption(name, distance, address, hours, phone, link, thumbnail, i, coorsonly);
					createMarker(latlng, name, distance, address, hours, phone, link, thumbnail, i);
					bounds.extend(latlng);
				}}
				map.fitBounds(bounds);
				fitToMarkers(markers);
				if(locationDetails)locationSelect.style.visibility = "visible";
				if(locationDetails)locationSelect.onchange = function() {
					var markerNum = locationSelect.options[locationSelect.selectedIndex].value;
					google.maps.event.trigger(markers[markerNum], "click");};
			}else if(gps && ((mapContainer.dataset.gps=='results' && !gpscheck) == false )){
				clearLocations();
				//console.log(1);
				map.panTo(center);
				createMarker(center, 'Current Location', '0', 'No Nearby Locations', '', '', '', '', 0);
				fitToMarkers(markers);
				setTimeout(function(){google.maps.event.trigger(markers[0], "click");},1000);
			}else if(!gps){
				clearLocations();
				//console.log(2);
				map.panTo(center);
				createMarker(center, '', '0', 'No Nearby Locations', '', '', '', '', 0);
				fitToMarkers(markers);
			};
		//console.log(center+' '+radius+' '+coorsonly+' '+gps);
		if(gps)gpscheck=true;
		mapping=false;
		});
	}

    function createMarker(latlng, name, distance, address, hours, phone, link, thumbnail, i){
		//console.log('createMarker: '+latlng);
		var html = mapContainer.dataset.html.replace('{link}',"<a href='"+link+"'>"+link+"</a>").replace('{phone}',"<a href='tel:"+phone+"'>"+phone+"</a>").replace('{distance}',distance).replace('{address}',address).replace('{name}',name);
        var marker = new google.maps.Marker({map: map,icon: mapContainer.dataset.icon ,position: latlng});
        google.maps.event.addListener(marker, "click", function() {infoWindow.setContent(html);infoWindow.open(map, marker);});
        markers.push(marker);
		if(jQuery('#locationSelect_'+i).length > 0)marker.addListener('click', function(event) {
			jQuery('.locationSelect').removeClass('hpl_selected');
			jQuery('#locationSelect_'+i).addClass('hpl_selected').css('display','block');
		});}

       function createOption(name, distance, address, hours, phone, link, thumbnail, i, coorsonly){
          var div = document.createElement("div");
		  div.id = 'locationSelect_'+i;
		  div.className = 'locationSelect';
		  if(coorsonly && i>4)div.style.display = "none";
		  div.setAttribute("onclick","changeLocation(this)");
          div.dataset.num = i;
          div.innerHTML = "<div class='hpl_locationSelect'><div class='hpl_locationSelect_name'><h1>"+name+"</h1><p>"+(Math.round(parseInt(distance,0)*(mapContainer.dataset.unit=='km'?.609344:1)))+" "+mapContainer.dataset.unit+"</p></div>"+(thumbnail?"<div class='hpl_locationSelect_img' style='background-image:url("+thumbnail+")'/></div>":"")+"<div class='hpl_locationSelect_address'><p>"+address+"</p></div><div class='hpl_locationSelect_info'><table><tr><td><p><b>Distance:</b></p></td><td><p>"+(Math.round(parseInt(distance,0)*(mapContainer.dataset.unit=='km'?.609344:1)))+" "+mapContainer.dataset.unit+"</p></td></tr>"+(phone?"<tr><td><p><b>Phone:</b></p></td><td><p><a href='tel:"+phone+"'>"+phone+"</a></p></td></tr>":"")+(hours?"<tr><td><p><b>Hours:</b></p></td><td><p>"+hours+"</p></td></tr>":"")+(link?"<tr><td><p><b>More Info:</b></p></td><td><p><a href='"+link+"'>"+link+"</a></p></td></tr>":"")+"</table></div><div class='hpl_locationSelect_google'><a href='https://www.google.com/maps?q="+encodeURIComponent(address)+"'>Get Directions and Reviews on </a></div></div>";
          locationSelect.appendChild(div);}

    function downloadUrl(url, callback) {
        var request = window.ActiveXObject ?new ActiveXObject("Microsoft.XMLHTTP") :new XMLHttpRequest;
        request.onreadystatechange = function() {if (request.readyState == 4) {request.onreadystatechange = doNothing;callback(request.responseText, request.status);}};
        request.open("GET", url, true);
        request.send(null);}

    function parseXml(str) {
        if (window.ActiveXObject) {
            var doc = new ActiveXObject("Microsoft.XMLDOM");
            doc.loadXML(str);
            return doc;
        } else if (window.DOMParser) {
            return (new DOMParser).parseFromString(str, "text/xml");}}
		  
    function doNothing() {}

