<?php
/**
 * Plugin Name: H-cube Library
 * Description: A growing collectiong of tools, styles and elements to be shared amongst websites developed by H-cube Marketing.
 * Version: 0.3 Alpha
 
 * Author(s): Josh Maxwell
 */
 
defined( 'ABSPATH' ) or die( );

function hpl_getUserIpAddr(){
    if(!empty($_SERVER['HTTP_CLIENT_IP'])){$ip = $_SERVER['HTTP_CLIENT_IP'];
    }elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    }else{$ip = $_SERVER['REMOTE_ADDR'];}
    return $ip;}

function hpl_header() {
	if( in_array(hpl_getUserIpAddr(), 
		['180.191.87.58'						//Mark Kenneth Suenan
		,'110.54.250.224'						//Mark Erasquin
		,'174.90.138.107','184.151.37.151'		//Trent Wehrhahn
		,'99.255.59.25'							//Jessica Perry
		,'199.126.38.27'						//Jesse Toporowski
		,'110.54.233.26'						//Jani Nash
		,'192.168.1.120'						//Geraldine Ferreras
		,'180.190.164.74'						//Armil Velos
		,'175.176.40.7','202.128.61.147'		//Mevan loshitha
		,'75.97.69.39'							//Peter Farrell
		,'216.211.34.150'						//Josh Maxwell
	])){ ?>
		<script>window['ga-disable-<?php echo get_option('hpl_gaid'); ?>'] = true;</script>
	<?php } ?>
		<!-- Global site tag (gtag.js) - Google Analytics -->
		<script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo get_option('hpl_gaid'); ?>"></script>
		<script>
		  window.dataLayer = window.dataLayer || [];
		  function gtag(){dataLayer.push(arguments);}
		  gtag('js', new Date());

		  gtag('config', '<?php echo get_option('hpl_gaid'); ?>');
		</script>

		<!-- Google Tag Manager -->
		<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
		new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
		j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
		'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
		})(window,document,'script','dataLayer','GTM-WXN3R4G');</script>
		<!-- End Google Tag Manager -->
			
    <?php
}
add_action('wp_head', 'hpl_header');

function hpl_footer() {
	?>
		<!-- Google Tag Manager (noscript) -->
		<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-WXN3R4G"
		height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
		<!-- End Google Tag Manager (noscript) -->
	<?php
}
add_action('wp_footer', 'hpl_footer');



if(get_option('hpl_search_on'))include 'php/fb_search.php';
if(get_option('hpl_gmap_on'))include 'php/fb_goomap.php';
if(get_option('hpl_lazy_on'))include 'php/fb_lazyload.php';
if(get_option('hpl_ytv_on'))include 'php/fb_youtube.php';
if(get_option('hpl_customcss'))include 'php/custom_css.php';
if(get_option('hpl_slider_on'))include 'php/fb_slider.php';
if(get_option('hpl_ajaxnav') && !is_admin())include 'php/ue_ajaxnav.php';

if( !is_admin() ){
	wp_enqueue_script('hpl_youtubeapi',"https://www.youtube.com/iframe_api" );
	wp_enqueue_script('hpl_gootags',get_site_url().'/wp-content/plugins/hcube-library/js/gootags.js',array('jquery') );
}
include 'php/settings.php';

add_action('admin_enqueue_scripts', 'admin_style');
function admin_style() {if(get_option('hpl_fusioncss'))wp_enqueue_style('admin-styles',get_site_url().'/wp-content/plugins/hcube-library/css/admin.css');}

register_activation_hook( __FILE__, 'hpl_initialize' );
function hpl_initialize(){
	require_once(ABSPATH."/wp-admin/includes/upgrade.php");
	global $wpdb;
	$charset_collate = $wpdb->get_charset_collate();
	$table_name = $wpdb->prefix . 'hpl_goomarks';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_name . " (
		  id int NOT NULL AUTO_INCREMENT ,
		  name varchar( 60 ) NOT NULL ,
		  address varchar( 80 ) NOT NULL ,
		  lat float( 10, 6 ) NOT NULL ,
		  lng float( 10, 6 ) NOT NULL ,
		  thumbnail TEXT NOT NULL ,
		  phone TEXT NOT NULL ,
		  hours TEXT NOT NULL ,
		  link TEXT NOT NULL ,
		  PRIMARY KEY  (id)
	) ENGINE = MYISAM 
	" . $charset_collate . " ; ";
	dbDelta($sql);
}

register_uninstall_hook(__FILE__, 'hpl_uninstall');
function hpl_uninstall(){
    global $wpdb;
    $table_name = $wpdb->prefix . 'hpl_goomarks';
    $sql = "DROP TABLE IF EXISTS ". $table_name;
    $wpdb->query($sql);
}
