<div class="team-gallery-section">
	<div class="container">
		<div class="row">
			<div class="col-lg-12">

				<?php
					$team_gallery_title = get_sub_field('team_gallery_title');
					$team_gallery = get_sub_field('team_gallery');

					echo '<h2>' . $team_gallery_title . '</h2>';
					echo '<div class="team-slider">';

					foreach ($team_gallery as $t) {
						$image = $t['image']['url'];
						$name = $t['name'];
						$title = $t['title'];
						$letters = $t['letters'];
						if (!$letters) {
							$letters = '&nbsp;';
						}
						$link = $t['link'];

						echo '<div class="col-md-3">';
						echo '<a href="'.$link.'">';
						echo '<img src="'.$image.'">';
						echo '<div class="caption">';
						echo '<span class="name">'.$name.'</span>';
						echo '<span class="title">'.$title.'</span>';
						echo '<span class="letters">'.$letters.'</span>';
						echo '</div>';
						echo '<span class="learn-more-button">Read Full Bio</span>';
						echo '</a>';
						echo '</div>';
					}

					echo '</div>';

				?>
			</div>
		</div>
	</div>
	<script type="text/javascript">
		jQuery(document).ready(function() {
			jQuery('.team-gallery-section .team-slider').slick({
				infinite: true,
				slidesToShow: 4,
				slidesToScroll: 4,
				dots: false,
				responsive: [
					{
						breakpoint: 768,
						settings: {
							slidesToShow: 2,
							slidesToScroll: 2,
							infinite: true,
							dots: false
						}
					}
				]
			});
		});
	</script>
</div>