<?php
$services_background = get_sub_field('background_image');
$services_link = get_sub_field('services_link');
?>
<section class="feature_section services-section" style="background: url(<?php echo $services_background['url']; ?>) center center no-repeat">
    <div class="container">
        <section class="featureinner_content">
            <h3><?php echo get_sub_field('services_title'); ?></h3>
            <ul>

                <?php
                $featured_services = get_sub_field('services');
                $first = true;
                $count = 0;

                foreach ($featured_services as $service) {
                    $title = $service['name'];
                    $sub_title = $service['sub_title'];
                    $description = $service['description'];
                    $link = $service['link'];
                    $image = $service['image']['url'];
                    $width = $service['image']['width'];
                    $height = $service['image']['height'];
                    $alt = $service['image']['alt'];
                    if ($first) {
                        $class = "first service";
                        $first = false;
                    }
                    else {
                        $class = "service";
                    }

                    echo '<li>';
                    echo    '<a href="'.$link.'">';
                    echo        '<img src="'.$image.'" alt="'.$alt.'">';
                    echo        '<h4>'.$title.'</h4>';
                    echo        '<em>'.$sub_title.'</em>';
                    echo        '<span>'.$description.'</span>';
                    echo    '</a>';
                    echo '</li>';

                    $count++;

                }

                ?>


            </ul>
            <div class="clear"></div>

        </section> 
    </div>
</section>