<?php

require_once dirname(__FILE__) . '/lessphp/lessc.inc.php';

add_action('wp_enqueue_scripts', 'cpm_theme_base_scripts');
function cpm_theme_base_scripts() {
	wp_enqueue_script('jquery', 'https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js', array(), null, true);
	// wp_enqueue_script('bootstrap', get_template_directory_uri().'/assets/bootstrap/js/bootstrap.min.js', array(), null, true);
	wp_enqueue_script('main', get_template_directory_uri().'/assets/js/main.js', array(), null, true);

	wp_enqueue_style('font-awesome', 'https://maxcdn.bootstrapcdn.com/font-awesome/4.6.3/css/font-awesome.min.css', false, null);
	wp_enqueue_style('google-fonts', 'https://fonts.googleapis.com/css?family=Cinzel:400,700|Raleway:400,700', false, null);

	wp_enqueue_style('bootstrap', get_template_directory_uri().'/assets/bootstrap/css/bootstrap.min.css', false, null);

	wp_enqueue_style('main', get_template_directory_uri().'/assets/css/main.css', false, null);
	wp_enqueue_style('responsive', get_template_directory_uri().'/assets/css/responsive.css', false, null);	

	cpm_compile_less(
		array(
			'../assets/less/main.less' => '../assets/css/main.css',
			'../assets/less/responsive.less' => '../assets/css/responsive.css'
		),
		dirname(__FILE__) . '/'
	);
}

function cpm_compile_less($files, $current_path) {
	$less = new lessc;

	$variables = array();

	$primary_color = get_field('primary_color', 'options');
	$variables['primary-color'] = $primary_color ? $primary_color : '#ccc';
	
	$secondary_color = get_field('secondary_color', 'options');
	$variables['secondary-color'] = $secondary_color ? $secondary_color : '#dddddd';
	
	$body_font_family = get_field('body_font_family', 'options');
	$variables['body-font-family'] = $body_font_family ? $body_font_family['font'] : 'Open Sans';
	
	$body_font_color = get_field('body_font_color', 'options');
	$variables['body-font-color'] = $body_font_color ? $body_font_color : '#333';
	
	$body_font_size = get_field('body_font_size', 'options');
	$variables['body-font-size'] = $body_font_size ? $body_font_size . 'px' : '16px';
	
	$header_font_family = get_field('header_font_family', 'options');
	$variables['header-font-family'] = $header_font_family ? $header_font_family['font'] : 'Open Sans';
	
	$header_font_color = get_field('header_font_color', 'options');
	$variables['header-font-color'] = $header_font_color ? $header_font_color : '#333333';
	
	$h1_font_size = get_field('h1_font_size', 'options');
	$variables['h1-font-size'] = $h1_font_size ? $h1_font_size . 'px' : '36px';
	
	$h2_font_size = get_field('h2_font_size', 'options');
	$variables['h2-font-size'] = $h2_font_size ? $h2_font_size . 'px' : '32px';
	
	$h3_font_size = get_field('h3_font_size', 'options');
	$variables['h3-font-size'] = $h3_font_size ? $h3_font_size . 'px' : '28px';
	
	$h4_font_size = get_field('h4_font_size', 'options');
	$variables['h4-font-size'] = $h4_font_size ? $h4_font_size . 'px' : '24px';
	
	$h5_font_size = get_field('h5_font_size', 'options');
	$variables['h5-font-size'] = $h5_font_size ? $h5_font_size . 'px' : '20px';
	
	$h6_font_size = get_field('h6_font-size', 'options');
	$variables['h6-font-size'] = $h6_font_size ? $h6_font_size . 'px' : '16px';

	$style_variables = get_field('style_variables', 'options');
	if (!$style_variables) {
		$style_variables = [];
	}
	foreach ($style_variables as $style_variable) {
		if (!$style_variable['name'] || !$style_variable['value']) {
			continue;
		}

		$name = $style_variable['name'];
		$name = strtolower($name);
		$name = str_replace(' ', '-', $name);
		$name = str_replace('_', '-', $name);

		$value = $style_variable['value'];

		$variables[$name] = $value;
	}

	$additional_fonts = get_field('additional_fonts', 'options');
	if (!$additional_fonts) {
		$additional_fonts = [];
	}
	foreach ($additional_fonts as $additional_font) {
		if (!$additional_font['name'] || !$additional_font['value'] || !$additional_font['fallback']) {
			continue;
		}

		$name = $additional_font['name'];
		$name = strtolower($name);
		$name = str_replace(' ', '-', $name);
		$name = str_replace('_', '-', $name);

		$value = $additional_font['value']['font'];

		$fallback = $additional_font['fallback'];

		$variables[$name] = $value . ', ' . $fallback;
	}

	$less->setVariables($variables);
	$less->addImportDir(dirname(__FILE__) . '/../assets/less');

	
	foreach ($files as $src => $dest) {
		if (file_exists($current_path . $src)) {
			$less->compileFile($current_path . $src, $current_path . $dest);	
		}
	}
}


