<?php

/* Custom ajax loader */
// add_filter('wpcf7_ajax_loader', 'my_wpcf7_ajax_loader');
// function my_wpcf7_ajax_loader () {
// 	return  get_bloginfo('stylesheet_directory') . '/assets/img/ajax-loader.gif';
// }


if (!function_exists('cpm_filter_head')) {
	function cpm_filter_head() {
	  remove_action('wp_head', '_admin_bar_bump_cb');
	}
	add_action('get_header', 'cpm_filter_head');	
}

if (!function_exists('cpm_button')) {
	function cpm_button($atts) {
		if (isset($atts['link'])) {
			$link = $atts['link'];	
		}
		else {
			$link = '#';
		}

		if (isset($atts['text'])) {
			$text = $atts['text'];
		}
		else {
			$text = '#';
		}

		if (isset($atts['description'])) {
			$description = $atts['description'];
		}
		else {
			$description = '';
		}
		
		return '<a class="btn-download" href="'.$link.'">'.$text.' <span class="text-small">'.$description.'</span></a>';
	}
	add_shortcode('cpm_button', 'cpm_button');
}

if (!function_exists('cpm_theme_setup')) {
	function cpm_theme_setup() {
	    add_theme_support( 'post-thumbnails');
	}
	add_action( 'after_setup_theme', 'cpm_theme_setup' );	
}

if (!function_exists('cpm_custom_gallery')) {
	function cpm_custom_gallery($atts) {
		if (isset($atts['child_of'])) {
			$child_of = (int) $atts['child_of'];
		}
		else {
			$child_of = 0;
		}

		if (isset($atts['exclude'])) {
			$exclude = $atts['exclude'];
		}
		else {
			$exclude = array();
		}

		$pages = get_pages(array(
			'sort_order' => 'asc',
			'sort_column' => 'menu_order',
			'child_of' => $child_of,
			'exclude' => $exclude
		));

		$ret .= '<div class="custom-gallery">';

		foreach ($pages as $page) {
			$page_id = $page->ID;

			$ret .= '<div class="col-md-4 col-sm-4">';
			
			$featured_image = get_featured_image('large', $page_id);
			$width = $featured_image[1];
			$ret .= '<a href="'.get_permalink($page_id).'" style="width:'.$width.'px">';
			$ret .= "<img src=\"$featured_image[0]\">";

			$ret .= '<div class="gallery-caption"><span>';
			$ret .= $page->post_title;
			$ret .= '</span></div>';

			$ret .= '</a>';
			$ret .= '</div>';
		}

		$ret .= '</div>';

		return $ret;
	}
	add_shortcode('custom_gallery', 'cpm_custom_gallery');
}



if (!function_exists('cpm_seo_plugin')) {
	function cpm_seo_plugin($atts) {
		if (!isset($atts['name']) || !$atts['name']) {
			return;
		}
		$name = $atts['name'];

		ob_start();

		echo '<div class="ss">';
		include $name . '.php';
		echo '</div>';

		$r = ob_get_contents();
		ob_end_clean();

		return $r;
	}
	add_shortcode('seo_plugin', 'cpm_seo_plugin');	
}
