<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <?php wp_head(); ?>
  <title><?php wp_title(); ?></title>

  <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
      <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
      <![endif]-->
    </head>
    <body <?php body_class(); ?>>

      <header>
        <?php if ($pre_header_bar = get_field('pre_header', 'options')): ?>
          <div class="pre-header text-center">
            <div class="container">
              <div class="row">
                <?php echo do_shortcode($pre_header_bar); ?>
              </div>
            </div>
          </div>
        <?php endif; ?>
        
        <div class="header">
          <div class="container">
            <div class="row">
              <div class="col-lg-4 header-left">
                <?php 
                  if ($header_logo = get_field('header_logo', 'options')):
                    $width = $header_logo['width'] / 2;
                    $height = $header_logo['height'] / 2;
                    $src = $header_logo['url'];
                    $alt = $header_logo['alt'];
                    echo '<a href="'.get_bloginfo('siteurl').'"><img class="header-logo" src="'.$src.'" alt="'.$alt.'" width="'.$width.'" height="'.$height.'"></a>';
                  endif; 
                ?>
              </div>
              <div class="col-lg-4 header-center">
                <?php
                if ($social_links = get_field('social_links', 'options')) {
                  echo '<ul class="social">';
                  foreach ($social_links as $social_link) {
                    echo '<li><a target="_blank" href="'.$social_link['url'].'" title="'.$social_link['name'].'"><i class="fa '.$social_link['icon'].'"></i></a></li>';
                  }
                  echo '</ul>';
                }
                ?>
              </div>
              <div class="col-lg-4 header-right">
                <?php if ($phone_number = get_field('phone_number', 'options')): ?>
                  <div class="header-phone lead">
                    <i class="fa fa-mobile"></i>
                    <a href="tel:<?php echo strip_phone_number($phone_number); ?>"><?php echo $phone_number ?></a>
                  </div>
                <?php endif; ?>
                <?php if ($header_address = get_field('address', 'options')): ?>
                  <div class="header-address lead">
                    <i class="fa fa-map-marker"></i>
                    <?php echo $header_address; ?>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>

        <div class="nav-wrapper">
          <div class="container">
            <div class="row">
              <div class="col-lg-12 text-center">
                <ul class="header-nav">
                  <?php
                  wp_nav_menu(array(
                    'walker' => new CPM_Nav_Walker,
                    'theme_location' => 'primary_navigation',
                    'make_select' => false,
                    'class' => 'primary-nav',
                    'items_wrap' => '%3$s'
                    )); 
                    ?>
                  </ul>
                </div>
              </div>
            </div>
          </div>

      </header>