<?php

add_shortcode('pagelist', 'cpm_pagelist_shortcode');
add_shortcode('page_list', 'cpm_pagelist_shortcode');
add_shortcode('page-list', 'cpm_pagelist_shortcode');
add_shortcode('cpm-pagelist', 'cpm_pagelist_shortcode');
add_shortcode('sitemap', 'cpm_pagelist_shortcode');

function cpm_pagelist_shortcode($atts) {
	$return = '';
	
	extract( shortcode_atts( array(
		'depth' => '0',
		'child_of' => '0',
		'exclude' => '0',
		'exclude_tree' => '',
		'include' => '0',
		'title_li' => '',
		'number' => '',
		'offset' => '',
		'meta_key' => '',
		'meta_value' => '',
		'show_date' => '',
		'sort_column' => 'menu_order, post_title',
		'sort_order' => 'ASC',
		'link_before' => '',
		'link_after' => '',
		'class' => '',
		'posts' => 'false'
	), $atts ) );

	$page_list_args = array(
		'depth'        => $depth,
		'child_of'     => $child_of,
		'exclude'      => $exclude,
		'exclude_tree' => $exclude_tree,
		'include'      => $include,
		'title_li'     => $title_li,
		'number'       => $number,
		'offset'       => $offset,
		'meta_key'     => $meta_key,
		'meta_value'   => $meta_value,
		'show_date'    => $show_date,
		'echo'         => 0,
		'sort_column'  => $sort_column,
		'sort_order'   => $sort_order,
		'link_before'  => $link_before,
		'link_after'   => $link_after,
	);

	$post_list_args = array(
		'depth'        => $depth,
		'child_of'     => $child_of,
		'exclude'      => $exclude,
		'exclude_tree' => $exclude_tree,
		'include'      => $include,
		'title_li'     => $title_li,
		'number'       => $number,
		'offset'       => $offset,
		'meta_key'     => $meta_key,
		'meta_value'   => $meta_value,
		'show_date'    => $show_date,
		'echo'         => 0,
		'sort_column'  => $sort_column,
		'post_type' => 'post',
		'sort_order'   => $sort_order,
		'link_before'  => $link_before,
		'link_after'   => $link_after,
	);

	if ($posts === 'true') {
		$posts = get_posts(array(
			'orderby' => 'date',
			'order' => 'DESC'
		));	
		$post_html = '<li class="page_item page_item_has_children"><span>Blog</span><ul class="children">';
		for ($i = 0; $i < count($posts); $i++) {
			$post = $posts[$i];
			$post_html .= '<li class="page_item"><a href="'.get_permalink($post->ID).'">'.$post->post_title.'</a></li>';
		}
		$post_html .= '</ul></li>';
	} else {
		$post_html = '';
	}
	

	return '<ul class="page-list">'.wp_list_pages( $page_list_args ).$post_html.'</ul>';
}
