<?php

add_shortcode( 'pagechildrengallery', 'cpm_pagelist_page_children_gallery_shortcode' );
add_shortcode( 'page_children_gallery', 'cpm_pagelist_page_children_gallery_shortcode' );
add_shortcode( 'page-children-gallery', 'cpm_pagelist_page_children_gallery_shortcode' );

function cpm_pagelist_page_children_gallery_shortcode( $atts ) {
	global $post, $current_pcg;

	// Attributes
	extract( shortcode_atts(
		array(
			'row_height' => '',
			'include' => '',
			'exclude' => '',
		), $atts )
	);

	if ($row_height) {
		$row_height = ' row_height="'.$row_height.'" ';
	}

	$ret = '';

	if (shortcode_exists('gallery')) {
		$ret .= '[smart-grid target="_self" lightbox="none" '.$row_height.' style="3"]';
	}
	// 3

	$args = array(
		'sort_order' => 'ASC',
		'sort_column' => 'menu_order',
		'hierarchical' => 1,
		'exclude' => $exclude,
		'include' => '',
		'meta_key' => '',
		'meta_value' => '',
		'authors' => '',
		'child_of' => $post->ID,
		'parent' => -1,
		'exclude_tree' => '',
		'number' => '',
		'offset' => 0,
		'post_type' => 'page',
		'post_status' => 'publish'
	); 
	$pages = get_pages($args); 



	$thumbnails = array();
	$current_pcg = array();

	if ($include) {
		$include = explode(',', $include);
		foreach ($include as $i) {
			$i = (int) $i;
			$o = new stdClass;
			$o->ID = $i;
			array_unshift($pages, $o);
		}	
	}

	foreach ($pages as $page) {
		$thumbnail = get_post_thumbnail_id($page->ID);
		$current_pcg[$thumbnail] = $page->ID;
		$thumbnails[] = $thumbnail;
	}

	if (shortcode_exists('gallery')) {
		$ret .= '[gallery columns="2" ids="'.implode(',', $thumbnails).'"]';	
	}
	
	if (shortcode_exists('gallery')) {
		$ret .= '[/smart-grid]';
	}

	add_filter('get_post_metadata', 'cpm_pagelist_post_metadata_filter', 10, 4);
	$ret = do_shortcode($ret);
	$current_pcg = null;
	remove_filter( 'get_post_metadata', 'cpm_pagelist_post_metadata_filter', 10 );

	return $ret;

}

function cpm_pagelist_post_metadata_filter($value, $object_id, $meta_key, $single) {
	global $current_pcg;

	if ($meta_key == 'sgg_external_url') {
		return get_permalink($current_pcg[$object_id]);
	}
	else if ($meta_key == '_wp_attachment_image_alt') {
		return get_the_title($current_pcg[$object_id]);
	}
	return $value;
}