<?php

add_shortcode('optio_link', 'cpm_optio_link_shortcode');
add_shortcode('optio-link', 'cpm_optio_link_shortcode');
add_shortcode('optiolink', 'cpm_optio_link_shortcode');

function cpm_optio_link_shortcode($atts) {
	extract( shortcode_atts(
	    array(
	      'title' => '',
	      'image' => '',
	      'page' => '',
	      'layout' => '',
	      'link_only' => '',
	      'width' => '',
	      'class' => '',
	      'watch' => 'false'
	    ), $atts)
	  );

	  if ($layout === 'right') {
	    $class .= " optio-box right";
	  }
	  else if ($layout === 'left') {
	    $class .= " optio-box left";
	  }
	  else {
	    $class .= " optio-box";
	  }

	  $title = str_replace('|', '<br />', $title);

	  $slug = slugify($title, '_');

	  if ($image == '') {
	    $image = $slug;
	  }
	  if ($page == '') {
	    $page = $slug;
	  }

	  $output = '';
	  
	  $href = admin_url('admin-ajax.php');

	  if ($link_only == "true") {
	    $output .=    '<a data-page="'.$page.'" href="'.$href.'" class="cp-optio-lightbox" title="'.get_bloginfo('name').' - '.strip_tags($title).'">'.$title.'</a>';
	    if ($watch == "true") {
	    	$output .=    '<a data-page="'.$page.'" href="'.$href.'" class="watch cp-optio-lightbox" title="'.get_bloginfo('name').' - '.strip_tags($title).'">Watch</a>';
	    }

	    return $output;
	  }

	  if ($width) {
	    $width = "width: ".$width.";";
	  }

	  $output .= '<div style="'.$width.'" class="'.$class.'">';
	  $output .=  '<a data-page="'.$page.'" href="'.$href.'" class="cp-optio-lightbox" title="'.get_bloginfo('name').' - '.strip_tags($title).'">';
	  $output .= '  <img alt="'.get_bloginfo('name').' - '.strip_tags($title).'" height="101" src="'.plugins_url('assets/img/'.$image, __FILE__).'" width="135" />';
	  $output .=  '</a>';

	  $output .=  '<div class="nestedbox">';
	  $output .=    '<a data-page="'.$page.'" href="'.$href.'" class="cp-optio-lightbox" title="'.get_bloginfo('name').' - '.strip_tags($title).'">'.$title.'</a>';
	  $output .=  '</div>';

	  $output .= '</div>';


	  return $output;
}