<?php

/**
	 * Add TinyMCE buttons
	 */
	
	function optio_dentistry_buttons() {
	        add_filter( 'mce_external_plugins', 'optio_dentistry_add_buttons' );
	        add_filter( 'mce_buttons', 'optio_dentistry_register_buttons' );
	}
	
	function optio_dentistry_add_buttons( $plugins ) {
	        wp_enqueue_style( 'optio-mce', plugins_url( '../assets/css/mce-plugin.css', __FILE__ ) );
	        $plugins['optio_dentistry'] = plugin_dir_url( __FILE__ ) . '../assets/js/mce-plugin.js';
	        return $plugins;
	}
	
	function optio_dentistry_register_buttons( $buttons ) {
	        array_push( $buttons, 'optio-library', 'optio-video', 'optio-lightbox' );
	        return $buttons;
	}
	
	add_action( 'admin_init', 'optio_dentistry_buttons' );
	
	/**
	 * TinyMCE dialogs
	 */
	
	function optio_dentistry_dialog( $dialog_id = 'insert-video' ) {
	        wp_enqueue_script( 'optio-dialog', plugins_url( '../assets/js/dialog.js', __FILE__ ), array( 'jquery' ), false, true );
	        wp_enqueue_style( 'optio-dialog', plugins_url( '../assets/css/dialog.css', __FILE__ ) );
	        echo
	                '<html>
	                        <head>
	                                <title>Select a video</title>';
	                                wp_print_head_scripts();
	                                wp_print_styles();
	        echo
	                        '</head>
	                        <body>
	                                <section>
	                                        <input id="selected" type="hidden">
	                                        <input id="selected-title" type="hidden">
	                                        <header></header>
	                                        <div id="videos"></div>
	                                        <footer>
	                                                <a id="close" href="#">Cancel</a>';
	                                                if ( $dialog_id == 'insert-video' ) echo '<button id="insert" disabled="disabled">Insert</button>';
	                                                if ( $dialog_id == 'insert-link' ) echo '<button id="link" disabled="disabled">Link</button>';
	        echo
	                                        '</footer>
	                                </section>';
	                                wp_print_footer_scripts();
	        echo
	                        '</body>
	                </html>';
	        exit();
	}
	
	function optio_dentistry_insert_video_dialog() {
	        optio_dentistry_dialog( 'insert-video' );
	}
	
	function optio_dentistry_insert_link_dialog() {
	        optio_dentistry_dialog( 'insert-link' );
	}
	
	add_action( 'wp_ajax_optio_insert_video_dialog', 'optio_dentistry_insert_video_dialog' );
	add_action( 'wp_ajax_optio_insert_link_dialog', 'optio_dentistry_insert_link_dialog' );