<?php

add_shortcode('site_link', 'cpm_site_link_shortcode');
function cpm_site_link_shortcode($atts, $content='') {
	// [site_link slug=""]Link to Another Multi-Site Home Page[/site_link]

	if (!isset($atts['slug']) || !$content) {
		return;
	}

	$search_slug = $atts['slug'];

	ob_start();

	$sites = get_sites();
	for ($i = 0; $i < count($sites); $i++) {
		$domain = $sites[$i]->domain;
		$parts = explode('.', $domain);
		$slug = $parts[0];
		if ($slug == $search_slug) {
			$blog_id = $sites[$i]->blog_id;
			$url = get_site_url($blog_id);
			break;
		}
	}

	if (!$url) {
		$url = get_site_url($sites[0]->blog_id);
	}

	echo '<a href="'.$url.'">' . do_shortcode($content) . '</a>';

	$r = ob_get_contents();
	ob_end_clean();
	return $r;
}
