<?php

function cpm_menus_services_nav($atts) {
	global $post;

	if (isset($atts['child_of'])) {
		$child_of = (int) $atts['child_of'];
	}
	else {
		$child_of = 0;
	}

	$current_page_id = $post->ID;

	$ret = '<ul class="services-nav">';

	$pages = get_pages(array(
		'sort_order' => 'asc',
		'sort_column' => 'menu_order',
		'child_of' => $child_of
	));

	$parent = get_page($child_of);
	$classes = ['parent'];
	$classes[] = 'page_' . $parent->ID;
	if ($current_page_id == $parent->ID) {
		$classes[] = 'active';
	}
	$ret .= '<li class="'.implode(' ', $classes).'">';
	$ret .= '<a href="'.get_permalink($parent->ID).'">';
	$ret .= $parent->post_title;
	$ret .= '</a>';
	$ret .= '</li>';

	foreach ($pages as $page) {
		$classes = [];
		$page_id = $page->ID;

		$classes[] = 'page_' . $page_id;

		if ($page_id == $current_page_id) {
			$classes[] = 'active';
		}

		$ret .= '<li class="'.implode(' ' , $classes).'">';
		$ret .= '<a href="'.get_permalink($page_id).'">';
		$ret .= $page->post_title;
		$ret .= '</a>';
		$ret .= '</li>';
	}

	$ret .= '</ul>';

	return $ret;
}
add_shortcode('services_nav', 'cpm_menus_services_nav');