<?php


class CPM_Nav_Walker extends Walker_Nav_Menu {
  function check_current($classes) {
    return preg_match('/(current[-_])|active|dropdown/', $classes);
  }


  function start_lvl(&$output, $depth = 0, $args = array()) {
    if (!$args->make_select) {
      $output .= "\n<ul class=\"dropdown-menu\">\n";
    }
  }
  
  function end_lvl(&$output, $depth=0, $args = array()) {
    if (!$args->make_select) {
      parent::end_lvl($output, $depth, $args);
    }
    else {
      
    }
  }

  function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
    $item_html = '';
    parent::start_el($item_html, $item, $depth, $args);

    $replace = str_pad('<option $1>', $depth+11, '-');
    if (isset($args->make_select) && $args->make_select) {
      $item_html = preg_replace('/<li[^>]*>/iU', '', $item_html);
      $item_html = preg_replace('/<a ([^>]*)>/iU', $replace, $item_html);
      $item_html = str_replace('href=', 'value=', $item_html);
      $item_html = str_replace('</a>', '</option>', $item_html);
      $item_html = str_replace('<i class="fa fa-home">', 'Home', $item_html);
      $item_html = str_replace('</i>', '', $item_html);
      $output .= $item_html;
      return;
    }

    if ($item->is_dropdown && ($depth === 0)) {
      $item_html = str_replace('<a', '<a class="dropdown-toggle disabled" data-toggle="dropdown" data-target="#"', $item_html);
      $item_html = str_replace('</a>', '</a>', $item_html);
    }
    elseif (stristr($item_html, 'li class="divider')) {
      $item_html = preg_replace('/<a[^>]*>.*?<\/a>/iU', '', $item_html);    
    }
    elseif (stristr($item_html, 'li class="nav-header')) {
      $item_html = preg_replace('/<a[^>]*>(.*)<\/a>/iU', '$1', $item_html);
    }   

    $output .= $item_html;
  }
  
  function end_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
    if (!isset($args->make_select) || !$args->make_select) {
      parent::end_el($output, $item, $depth, $args, $id);
    }
  }

  function display_element($element, &$children_elements, $max_depth, $depth = 0, $args, &$output) {
    $element->is_dropdown = !empty($children_elements[$element->ID]);

    if ($element->is_dropdown) {
      if ($depth === 0) {
        $element->classes[] = 'dropdown';
      } elseif ($depth === 1) {
        $element->classes[] = 'dropdown-submenu';
      }
    }

    parent::display_element($element, $children_elements, $max_depth, $depth, $args, $output);
  }
}

/**
 * Remove the id="" on nav menu items
 * Return 'menu-slug' for nav menu classes
 */
function cpm_nav_menu_css_class($classes, $item) {
  $slug = sanitize_title($item->title);
  $classes = preg_replace('/(current(-menu-|[-_]page[-_])(item|parent|ancestor))/', 'active', $classes);
  $classes = preg_replace('/^((menu|page)[-_\w+]+)+/', '', $classes);

  $classes[] = 'menu-' . $slug;

  $classes = array_unique($classes);

  return array_filter($classes, 'is_element_empty');
}

// add_filter('nav_menu_css_class', 'cpm_nav_menu_css_class', 10, 2);
// add_filter('nav_menu_item_id', '__return_null');

/**
 * Clean up wp_nav_menu_args
 *
 * Remove the container
 * Use cpm_Nav_Walker() by default
 */
function cpm_nav_menu_args($args = '') {

  $cpm_nav_menu_args['container'] = false;

  if (isset($args['make_select']) && $args['make_select']) {
    $cpm_nav_menu_args['items_wrap'] = '<select class=""><option>Select a Page...</option>%3$s</select>';
  }
  // else if (!$args['items_wrap']) {
  //   $cpm_nav_menu_args['items_wrap'] = '<ul class="%2$s">%3$s</ul>';
  // }

  if (current_theme_supports('bootstrap-top-navbar')) {
    $cpm_nav_menu_args['depth'] = 3;
  }

  // if (!$args['walker']) {
  //   $cpm_nav_menu_args['walker'] = new cpm_Nav_Walker();
  // }

  return array_merge($args, $cpm_nav_menu_args);
}

add_filter('wp_nav_menu_args', 'cpm_nav_menu_args');


