<?php

add_shortcode('phone_number', 'cpm_phone_number_shortcode');

function cpm_phone_number_shortcode($atts, $content='') {
	$r = '';

	if (isset($atts['number'])) {
		$phone_number = $atts['number'];
	}
	else {
		$phone_number = get_field('phone_number', 'options');
	}

	if (isset($atts['label'])) {
		$label = $atts['label'];
	}
	else if ($content) {
		$label = do_shortcode($content);
	}
	else {
		$label = $phone_number;
	}

	if (!$phone_number || $phone_number == '') {
		return;
	}

	if (isset($atts['class'])) {
		$class = $atts['class'];
	}
	else {
		$class = '';
	}

	$track = '';
	if (isset($atts['track']) && $atts['link'] && $atts['link'] != 'false') {
		$tracking_code = get_field('cpm_phone_number_tracking_code', 'options');
		if ($tracking_code) {
			$track = 'onclick="gtag_report_conversion(\'tel:'.strip_phone_number($phone_number).'\')"';	
		} 
	} 

	if (!isset($atts['link']) || $atts['link'] != 'false') {	
		$r .= '<a href="tel:' . strip_phone_number($phone_number) . '" class="'.$class.'" '.$track.'>';
	}
	else {
		$r .= '<span class="'.$class.'">';
	}

	if (isset($atts['icon'])) {
		$r .= '<i class="fa fa-'.$atts['icon'].'"></i>';
	}

	$r .= $label;

	if (!isset($atts['link']) || $atts['link'] != 'false') {
		$r .= '</a>';
	}
	else {
		$r .= '</span>';
	}




	return $r;
}	

