<?php

add_shortcode('image_cycle', 'cpm_image_cycle_shortcode');
add_shortcode('image-cycle', 'cpm_image_cycle_shortcode');
add_shortcode('imagecycle', 'cpm_image_cycle_shortcode');

function cpm_image_cycle_shortcode($atts) {
	ob_start();

	extract( shortcode_atts(
		array(
			'images' => '',
			'captions' => '',
			'links' => '',
			'alt' => '',
			'id' => 'cycle',
			'nojs' => 'false',
			'timeout' => 3000
		), $atts )
	);

	if (!$images) {
		return;
	}

	$images = explode(',', $images);
	$links = explode(',', $links);
	$captions = explode(',', $captions);
	$alt = explode(',', $alt);


	echo '<div class="cycle-slideshow" id="'.$id.'">';

	for ($i = 0; $i < count($images); $i++) {
		$image = $images[$i];
		$link = $links[$i] ? $links[$i] : '';
		$caption = $captions[$i] ? $captions[$i] : '';
		$alt = $alt[$i] ? $alt[$i] : '';

		echo '<div class="slide">';
		echo '<a href="'.($link ? $link : '').'">';

		echo '	<img src="' . $image . '" alt="'.$alt.'" >';
		if ($caption) {
			echo '<div class="slide-caption">';
			echo $caption;
			echo '</div>';
		}

		echo '</a>';
		echo '</div>';
	}

	echo '</div>';

	?>
	<?php if ($nojs !== 'true'): ?>
	<script>
		jQuery(document).ready(function() {
			jQuery('.cycle-slideshow').cycle({
				slides: '> div.slide',
				timeout: <?php echo $timeout; ?>,
				next: jQuery('.<?php echo $id; ?>-slider-next'),
				prev: jQuery('.<?php echo $id; ?>-slider-prev')
			})
		});
	</script>
	<?php endif; ?>
	<?php 
	cpm_image_cycle_enqueue_scripts();

	$r = ob_get_contents();
	ob_end_clean();
	return $r;
}	

function cpm_image_cycle_enqueue_scripts() {
	wp_enqueue_script('jquery-cycle', plugin_dir_url(__FILE__) . '../assets/js/cycle.js');
	wp_enqueue_script('jquery-carousel', plugin_dir_url(__FILE__) . '../assets/js/carousel.js');
}