<?php

add_shortcode('email', 'cpm_email_shortcode');

function cpm_email_shortcode($atts) {
  $r = '';

  if (isset($atts['address'])) {
    $email = $atts['address'];
  }
  else {
    $email = get_field('email_address', 'options');
  }

  if (!$email || $email == '') {
    return;
  }

  if (isset($atts['class'])) {
    $class = $atts['class'];
  }
  else {
    $class = '';
  }

  if (!isset($atts['link']) || $atts['link'] != 'false') {  
    $r .= '<a href="mailto:' . $email . '" class="'.$class.'">';
  }
  else {
    $r .= '<span class="'.$class.'">';
  }

  if (isset($atts['icon'])) {
    $r .= '<i class="fa fa-'.$atts['icon'].'"></i>';
  }

  $r .= $email;

  if (!isset($atts['link']) || $atts['link'] != 'false') {
    $r .= '</a>';
  }
  else {
    $r .= '</span>';
  }


  return $r;
} 

