<?php

add_shortcode('cpm_map', 'cpm_maps_shortcode');
add_shortcode('cpm-map', 'cpm_maps_shortcode');
add_shortcode('cpmmap', 'cpm_maps_shortcode');

function cpm_maps_shortcode($atts, $content = "") {
	global $post;

	ob_start();

	$map_option = get_field('map', 'options');

	extract(shortcode_atts(array(
		'phone_number' => get_field('phone_number', 'options'),
		'title' => get_bloginfo('name'),
		'email' => get_field('email_address', 'options'),
		'width' => '100%',
		'height' => '350px',
		'lat' => $map_option ? $map_option['lat'] : '',
		'lng' => $map_option ? $map_option['lng'] : '',
		'zoom' => $map_option ? $map_option['zoom'] : '',
		'center_lat' => $map_option ? $map_option['center_lat'] : '',
		'center_lng' => $map_option ? $map_option['center_lng'] : '',
		'address' => false,
		'html' => false
	), $atts));

	if ($content == '') {
		$address = get_field('address', 'options');
		if (!$address) {
			$address = $map_option['address'];
		}
	}
	else {
		$address = $content;
	}

	$address = preg_replace( "/\r|\n/", "", $address );
	$address = preg_replace('/<a href=\"(.*?)\">(.*?)<\/a>/', "", $address);

	
	$stripped_phone = preg_replace('/[\(\)\. -]/i', '', $phone_number);

	$markerHTML = $address;
	if ($title) {
		$markerHTML = '<strong>'.$title.'</strong><br />' . $address;
	}

	if (!$address) {
		$markerAddress = str_replace("<br />", ",", $address);	
	}
	else {
		$markerAddress = $address;
	}
	


	?>

	<?php if ($post->post_type == 'lightbox_page'): ?>
		<div class="map-print"><a href="#" onclick="window.print()">Print Map</a></div>
		<div class="contact-info"><a href="tel:<?php echo $stripped_phone; ?>"><?php echo $phone_number; ?></a> | <a target="_blank" href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a></div>
		<?php if (!isset($_REQUEST['lightbox']) || $_REQUEST['lightbox'] !== 'true') { ?>
			<div class="back-button"><a href="#" onclick="nav_back()">&#8592; Back</a></div>	
		<?php } ?>		
	<?php endif; ?>

	<div id="cpm-map" style="width:<?php echo $width; ?>;height:<?php echo $height; ?>;"></div>
	<script>
			jQuery(document).ready(function() {
				setTimeout(function() {

					var markerHTML = "<?php echo $markerHTML; ?>";
					var $marker = jQuery("<div>"+markerHTML+"</div>");
					var markerAddress = "<?php echo $markerAddress; ?>";

					var args = {
						zoom: 'fit',
						maxZoom: 16,
						markers: [
							{
								html: $marker.html(),
								popup: true
							}
						]
					};

					<?php if ($lat): ?>
						args.markers[0].latitude = "<?php echo $lat; ?>";
					<?php endif; ?>
					<?php if ($lng): ?>
						args.markers[0].longitude = "<?php echo $lng; ?>";
					<?php endif; ?>
					<?php if ($address && !$lng && !$lat): ?>
						args.markers[0].address = markerAddress;
					<?php endif; ?>
					<?php if ($zoom): ?>
						args.zoom = <?php echo $zoom; ?>;
					<?php endif; ?>

					jQuery('#cpm-map').gMap(args);

				}, 700);
		});
	</script>

	<?php

	$ret = ob_get_contents();
	ob_end_clean();

	return $ret;
}
