<?php 

function cpm_maps_init() {
	add_action('wp_enqueue_scripts', 'cpm_maps_enqueue_scripts');
}
add_action( 'init', 'cpm_maps_init' );

function cpm_maps_enqueue_scripts() {
	$api_key = get_field('cpm_google_maps_api_key', 'options');
	wp_enqueue_script('google-maps', '//maps.google.com/maps/api/js?sensor=false&key='.$api_key);
}

function cpm_maps_admin_init() {
	add_action('admin_enqueue_scripts', 'cpm_maps_admin_enqueue_scripts');
}
add_action('admin_init', 'cpm_maps_admin_init');

function cpm_maps_admin_enqueue_scripts() {
	wp_dequeue_script('googlemaps-api');

	$api_key = get_field('cpm_google_maps_api_key', 'options');
	if (!$api_key) {
		$api_key = CPM_MAPS_API_KEY;
	}
	wp_enqueue_script('googlemaps-api', '//maps.googleapis.com/maps/api/js?sensor=false&libraries=places&key='.$api_key, array(), '3', false);
}

