<?php

add_action('wp_ajax_cpm_lightbox_rebuild_lightboxes', 'cpm_lightbox_rebuild_lightboxes_ajax');

function cpm_lightbox_rebuild_lightboxes_ajax() {
	echo cpm_lightbox_rebuild_lightboxes();
	die();
}

function cpm_lightbox_rebuild_lightboxes() {
	$loader = new Twig_Loader_Filesystem(dirname(__FILE__).'/../content');
	$twig = new Twig_Environment($loader, array(
	));

	$lightboxes_created = 0;

	$lightbox_files = scandir(dirname(__FILE__) . '/../content');
	foreach ($lightbox_files as $file) {
		if ($file == '.' || $file == '..') {
			continue;
		}
		$file_parts = explode('.', $file);
		$slug = slugify($file_parts[0]);
		$title = unslugify($slug);

		if (lightbox_page_exists($slug)) {
			continue;
		}

		$content = $twig->render($file, array(
			'variable' => 'Value'
		));

		$args = array(
			'post_name' => $slug,
			'post_title' => $title,
			'post_type' => 'lightbox_page',
			'post_content' => $content,
			'post_status' => 'publish'
		);
		$new_post_id = wp_insert_post($args);

		$lightboxes_created++;
		
	}

	$r['success'] = true;


	$r['message'] = $lightboxes_created . ' lightboxes created.';

	return json_encode($r);
}