<?php

function cpm_lightbox_wp_footer() {
	$welcome_lightbox_image = get_field('welcome_lightbox_image', 'options');
	$welcome_lightbox_link = get_field('welcome_lightbox_link', 'options');
	$welcome_lightbox_html = get_field('welcome_lightbox_html', 'options');
	$welcome_lightbox_enabled = get_field('welcome_lightbox_enabled', 'options');
	if (!$welcome_lightbox_enabled || (!$welcome_lightbox_html && !$welcome_lightbox_link && !$welcome_lightbox_image)) {
		return;
	}
	?>
	<div id="welcome-lightbox" style="display:none;">
		<?php if ($welcome_lightbox_html) { ?>
			<?php echo $welcome_lightbox_html; ?>
		<?php } else { ?>
			<a href="<?php echo $welcome_lightbox_link; ?>">
				<img src="<?php echo $welcome_lightbox_image['url']; ?>" alt="<?php echo $welcome_lightbox_image['alt']; ?>" />		
			</a>
		<?php } ?>
	</div>
	<script>
		jQuery(document).ready(function() {
			if (!jQuery.cookie('welcome-lightbox')) {
				jQuery.fancybox("#welcome-lightbox", {padding: 0});
				jQuery.cookie('welcome-lightbox', 'true', {expires: 7});	
			}
		});
	</script>
	<?php
}
add_action('wp_footer', 'cpm_lightbox_wp_footer');