<?php

add_action('init', 'cpm_lightbox_post_type');

function cpm_lightbox_post_type() {
	$labels = array(
		'name'                => _x( 'Lightbox Pages', 'Post Type General Name', 'text_domain' ),
		'singular_name'       => _x( 'Lightbox Page', 'Post Type Singular Name', 'text_domain' ),
		'menu_name'           => __( 'Lightbox Pages', 'text_domain' ),
		'parent_item_colon'   => __( 'Parent Item:', 'text_domain' ),
		'all_items'           => __( 'All Items', 'text_domain' ),
		'view_item'           => __( 'View Item', 'text_domain' ),
		'add_new_item'        => __( 'Add New Item', 'text_domain' ),
		'add_new'             => __( 'Add New', 'text_domain' ),
		'edit_item'           => __( 'Edit Item', 'text_domain' ),
		'update_item'         => __( 'Update Item', 'text_domain' ),
		'search_items'        => __( 'Search Item', 'text_domain' ),
		'not_found'           => __( 'Not found', 'text_domain' ),
		'not_found_in_trash'  => __( 'Not found in Trash', 'text_domain' ),
	);
	$rewrite = array(
		'slug'                => 'lightbox',
		'with_front'          => false
	);
	$args = array(
		'label'               => __( 'lightbox_page', 'text_domain' ),
		'description'         => __( 'Lightbox Page', 'text_domain' ),
		'labels'              => $labels,
		'supports'            => array( 'title', 'editor' ),
		'hierarchical'        => false,
		'public'              => true,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'menu_position'       => 5,
		'can_export'          => true,
		'has_archive'         => false,
		'exclude_from_search' => true,
		'publicly_queryable'  => true,
		'rewrite'             => $rewrite,
		'capability_type'     => 'page',
	);
	register_post_type( 'lightbox_page', $args );
}
