<?php 

add_action('wp_ajax_cpm_forms_rebuild_forms', 'cpm_forms_rebuild_forms_ajax');

function cpm_forms_rebuild_forms_ajax() {
	echo cpm_forms_rebuild_forms();
	die();
}

function cpm_forms_rebuild_forms() {
	$r = array();

	$forms_created = 0;

	$form_path = dirname(__FILE__) . '/../content';

	$form_folders = scandir($form_path);
	foreach ($form_folders as $form_folder) {
		if ($form_folder == '.' || $form_folder == '..' || $form_folder == 'patient-referral' || $form_folder == 'patient-registration') {
			continue;
		}
		if (!is_dir($form_path . '/' . $form_folder)) {
			continue;
		}
		$slug = $form_folder;
		$title = unslugify($slug);

		if (form_exists($slug)) {
			continue;
		}

		$content_template = file_get_contents($form_path.'/'.$form_folder.'/content.html');

		$loader = new Twig_Loader_Filesystem($form_path.'/'.$form_folder);
		$twig = new Twig_Environment($loader, array());

		$content = $twig->render('content.html', array(
			'variable' => 'Value'
		));

		$email_address = get_field('email_address', 'options');
		$site_name = get_bloginfo('name');
		$phone_number = get_field('phone_number', 'options');
		$site_url = get_bloginfo('url');
		$primary_color = get_field('primary_color', 'options');

		$mail1 = (array) json_decode(file_get_contents($form_path.'/'.$form_folder.'/mail.json'));
		$mail1['body'] = file_get_contents($form_path.'/'.$form_folder.'/mail.html');
		foreach (array_keys($mail1) as $key) {
			$mail1[$key] = preg_replace('/\[site_name\]/i', $site_name, $mail1[$key]);
			$mail1[$key] = preg_replace('/\[site_email\]/i', $email_address, $mail1[$key]);
			$mail1[$key] = preg_replace('/\[site_url\]/i', $site_url, $mail1[$key]);
			$mail1[$key] = preg_replace('/\[site_phone\]/i', $phone_number, $mail1[$key]);
			$mail1[$key] = preg_replace('/\[primary_color\]/i', $primary_color, $mail1[$key]);
		}

		$mail2 = (array) json_decode(file_get_contents($form_path.'/'.$form_folder.'/mail2.json'));
		$mail2['body'] = file_get_contents($form_path.'/'.$form_folder.'/mail2.html');
		foreach (array_keys($mail2) as $key) {
			$mail2[$key] = preg_replace('/\[site_name\]/i', $site_name, $mail2[$key]);
			$mail2[$key] = preg_replace('/\[site_email\]/i', $email_address, $mail2[$key]);
			$mail2[$key] = preg_replace('/\[site_url\]/i', $site_url, $mail2[$key]);
			$mail2[$key] = preg_replace('/\[site_phone\]/i', $phone_number, $mail2[$key]);
			$mail2[$key] = preg_replace('/\[primary_color\]/i', $primary_color, $mail2[$key]);
		}

		$messages = array(
			"mail_sent_ok" => "Your message was sent successfully. Thanks.",
			"mail_sent_ng" => "Failed to send your message. Please try later or contact the administrator by another method.",
			"validation_error" => "Validation errors occurred. Please confirm the fields and submit it again.",
			"spam" => "Failed to send your message. Please try later or contact the administrator by another method.",
			"accept_terms" => "Please accept the terms to proceed.",
			"invalid_required" => "Please fill the required field.",
			"invalid_too_long" => "The field is too long.",
			"invalid_too_short" => "The field is too short.",
			"invalid_date" => "Date format seems invalid.",
			"date_too_early" => "This date is too early.",
			"date_too_late" => "This date is too late.",
			"upload_failed" => "Failed to upload file.",
			"upload_file_type_invalid" => "This file type is not allowed.",
			"upload_file_too_large" => "This file is too large.",
			"upload_failed_php_error" => "Failed to upload file. Error occurred.",
			"invalid_number" => "Number format seems invalid.",
			"number_too_small" => "This number is too small.",
			"number_too_large" => "This number is too large.",
			"quiz_answer_not_correct" => "Your answer is not correct.",
			"captcha_not_match" => "Your entered code is incorrect.",
			"invalid_email" => "Email address seems invalid.",
			"invalid_url" => "URL seems invalid.",
			"invalid_tel" => "Telephone number seems invalid."
			);
		$settings = "";

		$args = array(
			'post_name' => $slug,
			'post_title' => $title,
			'post_type' => 'wpcf7_contact_form',
			'post_content' => $content,
			'post_status' => 'publish'
			);
		$meta = array(
			'_form' => $content,
			'_mail' => $mail1,
			'_mail_2' => $mail2,
			'_messages' => $messages,
			'_additional_settings' => $settings,
			'_locale' => 'en_US'
			);

		error_log(print_r($meta, true));

		$new_post_id = wp_insert_post($args);
		foreach ($meta as $meta_key => $meta_value) {
			update_post_meta($new_post_id, $meta_key, $meta_value);
		}

		$forms_created++;

	}

	
	$r['success'] = true;

	$r['message'] = $forms_created . ' forms created.';

	return json_encode($r);
}