<?php

function cpm_foobar_wp_footer() {
	$primary_color = get_field('primary_color', 'options');
	if (!$primary_color) {
		$primary_color = '#666';
	}
	$body_font_family = get_field('body_font_family', 'options');
	if (!$body_font_family) {
		$body_font_family = 'Open Sans';
	} else {
		$body_font_family = $body_font_family['font'];
	}
	$foobar_html = get_field('foobar_html', 'options');
	$foobar_enabled = get_field('foobar_enabled', 'options');
	$foobar_style = get_field('foobar_style', 'options');
	if (!$foobar_html || !$foobar_enabled) {
		return;
	}
	?>
	<div>
		<style>
			<?php echo $foobar_style; ?>
		</style>
	</div>
	<script>
		jQuery(document).ready(function() {
			$foobar({
			  "height" : {
			    "bar" : 46
			  },      
			  "width": {
			    "left": "0", 
			    "center": "*",
			    "right": "0", 
			    "button": "0"
			  },
			  "message": {
		  		"font": {
		  			"size": "18px",
		  			"family": "<?php echo $body_font_family; ?>",
		  			"color": "#fff"
		  		},
		  		"aFont": {
		  			"size": "18px",
		  			"family": "<?php echo $body_font_family; ?>",
		  			"color": "#fff",
		  			"hover": {
		  				"decoration": "none"
		  			}
		  		}
			  },
			  "display" : {
			    "button": { 
			    	"type": "none" 
			    },
			    "backgroundColor" : "<?php echo $primary_color; ?>",
			    "theme": {
			      "bar": "x-white"
			    }
			  },		  
			  "messages": [
			    '<?php echo $foobar_html; ?>'
			  ]
			});	
		})
	</script>
	<?php
}
add_action('wp_footer', 'cpm_foobar_wp_footer');