<?php

add_shortcode('fb_wall', 'cpm_facebook_wall_shortcode');
add_shortcode('fbwwall', 'cpm_facebook_wall_shortcode');
add_shortcode('fb-wall', 'cpm_facebook_wall_shortcode');  

function cpm_facebook_wall_shortcode( $atts ) {
  

  extract(shortcode_atts(array(
    'id' => get_field('cpm_facebook_wall_page_id', 'options'),
    'access_token' => get_field('cpm_facebook_wall_token', 'options'),
    'show_guest_entries' => get_field('cpm_facebook_wall_show_guest_entries', 'options'),
    'show_comments' => get_field('cpm_facebook_wall_show_comments', 'options'),
    'max' => get_field('cpm_facebook_wall_max_posts', 'options'),
    'time_conversion' => get_field('cpm_facebook_wall_time_conversion', 'options'),
    'class' => get_field('cpm_facebook_wall_class', 'options'),
    'css' => get_field('cpm_facebook_wall_css', 'options')
  ), $atts));

  if ($css) {
    wp_enqueue_style('fb-wall-style', CPM_FACEBOOK_URL . '/' . $css);
  }

  $ret = '';
  $ret .= '<div class="'.$class.'" id="fb-wall"></div>';
  $ret .= '<script type="text/javascript">';
  $ret .= ' jQuery(document).ready(function() {';
  $ret .= '   jQuery("#fb-wall").fbWall({';
  $ret .= '     id: '."'".$id."',";  
  $ret .= '     accessToken: '."'".$access_token."',";    
  $ret .= '     show_guest_entries: '.($show_guest_entries?'true':'false').",";    
  $ret .= '     show_comments: '.($show_comments?'true':'false').",";    
  $ret .= '     max: '.($max?$max:10).",";    
  $ret .= '     time_conversion: '.($time_conversion?$time_conversion:12);          
  $ret .= '   });';
  $ret .= ' });';
  $ret .= '</script>';
  return $ret;
}
