<?php



add_action( 'admin_menu', 'cpm_facebook_menu' );
function cpm_facebook_menu() {
  add_submenu_page( 'cpm', 'Facebook', 'Facebook', 'edit_posts', 'fb-wall', 'cpm_facebook_options' ) ;

  
}

function cpm_facebook_options() {
  $currentWall = get_option( "FB_WALL_WALL_OPTIONS" );
  if ( is_serialized( $currentWall ) ) {$currentWall = unserialize( $currentWall );}

  $currentLike = get_option( "FB_WALL_LIKE_OPTIONS" );
  if ( is_serialized( $currentLike ) ) {$currentLike = unserialize( $currentLike );}

?>
  
<div class='wrap'>
  <div style='float:left; width:75%;'>
    <h1>FB Wall</h1>
    <p class="description">The following options allow you to set default values for the FB Wall Plugin.</p>
    <p class="description">These values will be overridden by any shortcode attributes.</p>
    
    
    <form method="post" action="options.php">
      <?php wp_nonce_field( 'update-options' ); ?>

      <fieldset>
      <h2>Wall Settings</h2>
      <table class="form-table">
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_WALL_OPTIONS['id']">Page ID: </label></th>
          <td><input style="width:75%;" type="text" name="FB_WALL_WALL_OPTIONS[id]" id="FB_WALL_WALL_OPTIONS['id']" value='<?php echo $currentWall['id']; ?>' /></td>
        </tr>
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_WALL_OPTIONS['access_token']">Token: </label></th>
          <td><textarea style="width:75%;" rows="3" name="FB_WALL_WALL_OPTIONS[access_token]" id="FB_WALL_WALL_OPTIONS['access_token']"><?php echo $currentWall['access_token']; ?></textarea></td>
        </tr>
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_WALL_OPTIONS['show_guest_entries']">Show Guest Entries: </label></th>
          <td><input style="width:75%;" type="text" name="FB_WALL_WALL_OPTIONS[show_guest_entries]" id="FB_WALL_WALL_OPTIONS['show_guest_entries']" value='<?php echo $currentWall['show_guest_entries']; ?>' /></td>
        </tr>
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_WALL_OPTIONS['show_comments']">Show Comments: </label></th>
          <td><input style="width:75%;" type="text" name="FB_WALL_WALL_OPTIONS[show_comments]" id="FB_WALL_WALL_OPTIONS['show_comments']" value='<?php echo $currentWall['show_comments']; ?>' /></td>
        </tr>
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_WALL_OPTIONS['max']">Max: </label></th>
          <td><input style="width:75%;" type="text" name="FB_WALL_WALL_OPTIONS[max]" id="FB_WALL_WALL_OPTIONS['max']" value='<?php echo $currentWall['max']; ?>' /></td>
        </tr>
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_WALL_OPTIONS['time_conversion']">Time Conversion: </label></th>
          <td><input style="width:75%;" type="text" name="FB_WALL_WALL_OPTIONS[time_conversion]" id="FB_WALL_WALL_OPTIONS['time_conversion']" value='<?php echo $currentWall['time_conversion']; ?>' /></td>
        </tr>
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_WALL_OPTIONS['class']">Class: </label></th>
          <td><input style="width:75%;" type="text" name="FB_WALL_WALL_OPTIONS[class]" id="FB_WALL_WALL_OPTIONS['class']" value='<?php echo $currentWall['class']; ?>' /></td>
        </tr>
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_WALL_OPTIONS['css']">CSS: </label></th>
          <td><input style="width:75%;" type="text" name="FB_WALL_WALL_OPTIONS[css]" id="FB_WALL_WALL_OPTIONS['css']" value='<?php echo $currentWall['css']; ?>' /></td>
        </tr>            
      </table>
      </fieldset>


      <fieldset>
      <h2>Like Button Settings</h2>
      <table class="form-table">
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_LIKE_OPTIONS['page']">Page URL: </label></th>
          <td><input style="width:75%;" type="text" name="FB_WALL_LIKE_OPTIONS[page]" id="FB_WALL_OPTIONS['FB_WALL_LIKE_OPTIONS']" value='<?php echo $currentLike['page']; ?>' /></td>
        </tr>
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_LIKE_OPTIONS['width']">Width: </label></th>
          <td><input style="width:75%;" type="text" name="FB_WALL_LIKE_OPTIONS[width]" id="FB_WALL_LIKE_OPTIONS['width']" value='<?php echo $currentLike['width']; ?>' /></td>
        </tr>
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_LIKE_OPTIONS['height']">Height: </label></th>
          <td><input style="width:75%;" type="text" name="FB_WALL_LIKE_OPTIONS[height]" id="FB_WALL_LIKE_OPTIONS['height']" value='<?php echo $currentLike['height']; ?>' /></td>
        </tr>
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_LIKE_OPTIONS['show_faces']">Show Faces: </label></th>
          <td><input type="checkbox" name="FB_WALL_LIKE_OPTIONS[show_faces]" id="FB_WALL_LIKE_OPTIONS['show_faces']" value='1' <?php if ( $currentLike['show_faces']==true ) {echo "checked='checked'";}?> /></td>
        </tr>
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_LIKE_OPTIONS['send']">Send: </label></th>
          <td><input type="checkbox" name="FB_WALL_LIKE_OPTIONS[send]" id="FB_WALL_LIKE_OPTIONS['send']" value='1' <?php if ( $currentLike['send']==true ) {echo "checked='checked'";}?> /></td>
        </tr>
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_LIKE_OPTIONS['color_scheme']">Color Scheme: </label></th>
          <td><input style="width:75%;" type="text" name="FB_WALL_LIKE_OPTIONS[color_scheme]" id="FB_WALL_LIKE_OPTIONS['color_scheme']" value='<?php echo $currentLike['color_scheme']; ?>' /></td>
        </tr>
        <tr valign="top">
          <th scope="row"><label for="FB_WALL_LIKE_OPTIONS['layout']">Layout: </label></th>
          <td><input style="width:75%;" type="text" name="FB_WALL_LIKE_OPTIONS[layout]" id="FB_WALL_LIKE_OPTIONS['layout']" value='<?php echo $currentLike['layout']; ?>' /></td>
        </tr>
      </table>
      </fieldset>

      <input type="hidden" name="action" value="update" />
      <input type="hidden" name="page_options" value="FB_WALL_LIKE_OPTIONS,FB_WALL_WALL_OPTIONS" />
      <p class="submit">
        <input type="submit" class="button-primary" value="<?php _e( 'Save Changes' ) ?>" />
      </p>
    </form>
    
  </div>
</div>

    
<?php

}


