<?php

register_activation_hook( __FILE__, "cpm_facebook_register" );
register_deactivation_hook( __FILE__, "cpm_facebook_deregister" );

add_action('cpm_facebook_check_token', 'cpm_facebook_check_update_token');

function cpm_facebook_register() {
  $timestamp = wp_next_scheduled( 'cpm_facebook_check_token' );
  if( $timestamp == false ){
    wp_schedule_event( time(), 'daily', 'cpm_facebook_check_token' );
  }

  $wallValues = array(
    'id' => '',
    'access_token' => '',
    'show_guest_entries' => 'false',
    'show_comments' => 'false',
    'max' => 10,
    'time_conversion' => 12,
    'class' => 'news-page',
    'css' => ''
    );

  $likeValues = array(
    'page' => '',
    'width' => 450,
    'height' => 30,
    'show_faces' => 'true',
    'color_scheme' => 'light',
    'action' => 'like',
    'layout' => 'standard',
    'send' => 'false'
    );

  if ( get_option( "FB_WALL_WALL_OPTIONS" ) ) {
    $current = get_option( "FB_WALL_WALL_OPTIONS" );
    if ( is_serialized( $current ) ) {
      $current = unserialize( $current );
    }
    $wallValues = array_merge( $wallValues, $current );
    update_option( "FB_WALL_WALL_OPTIONS", $wallValues );
  }
  else {
    add_option( "FB_WALL_WALL_OPTIONS", $wallValues );
  }

  if ( get_option( "FB_WALL_LIKE_OPTIONS" ) ) {
    $current = get_option( "FB_WALL_LIKE_OPTIONS" );
    if ( is_serialized( $current ) ) {
      $current = unserialize( $current );
    }
    $likeValues = array_merge( $likeValues, $current );
    update_option( "FB_WALL_LIKE_OPTIONS", $likeValues );
  }
  else {
    add_option( "FB_WALL_LIKE_OPTIONS", $likeValues );
  }

  cpm_facebook_check_update_token();

}

function cpm_facebook_deregister() {
  wp_clear_scheduled_hook( 'cpm_facebook_check_token' );
}

function cpm_facebook_check_update_token() {
  $currentWall = get_option( "FB_WALL_WALL_OPTIONS" );
  if ( is_serialized( $currentWall ) ) {$currentWall = unserialize( $currentWall );}
  
  $j = file_get_contents(CPM_FACEBOOK_AUTH_URL);
  $j = json_decode($j);
  
  $token = $j->accessToken;
  $expires = $j->expires;

  $old_token = $currentWall['access_token'];
  $current_date = date('Y-m-d');
  if (!$old_token || ($token != $old_token && $current_date > $expires)) {
    $currentWall['access_token'] = $token;
    update_option( "FB_WALL_WALL_OPTIONS", $currentWall );
  }
}
