<?php

add_action('wp_ajax_cpm_export_load_settings', 'wp_ajax_cpm_export_load_settings_ajax');

function wp_ajax_cpm_export_load_settings_ajax() {
	echo cpm_export_load_settings();
	die();
}

function cpm_export_load_settings() {
	$r = array();

	$updated= true;	

	$upload_dir = wp_upload_dir();
	$upload_path = $upload_dir['path'];
	$upload_url = $upload_dir['url'];
	$site_url = str_replace('https://', '', get_option('siteurl')); 
	$date = date('Y-m-d-H:m:s');
	$filename = 'export-' . $site_url . '-' . $date . '.doc';
	
	$url = $upload_url . '/' . $filename;
	$path = $upload_path . '/' . $filename;


	$posts = get_pages(array(
		'post_type' => 'page'
	));

	$data = '<html>';
	foreach ($posts as $post) {
		$data .= '<h1>' . $post->post_title . '</h1>';
		$content = $post->post_content;
		$content = wpautop($content);
		$content = str_replace("–", "-", $content);
		$content = str_replace("“", '"', $content);
		$content = str_replace("”", '"', $content);	
		$content = str_replace("’", "'", $content);
		$content = preg_replace('/<img .* \/>/i', '', $content);
		$data .= '<div style="page-break-after:always;">' . $content . '</div>';
	}
	$data .= '</html>';


	file_put_contents($path, $data);
	
	// file_put_contents(, data)

	if ($updated) {
		$r['success'] = true;	
		$r['message'] = 'Export Successful: <a href="'.$url.'" style="color: #fff;">Download</a>';
	}
	else {
		$r['error'] = true;
		$r['message'] = 'Unable to update export Settings';
	}
	
	

	return json_encode($r);
}