<?php

add_shortcode('latest_blog', 'cpm_latest_blog_shortcode');
add_shortcode('latest-blog', 'cpm_latest_blog_shortcode');
add_shortcode('latestblog', 'cpm_latest_blog_shortcode');

function cpm_latest_blog_shortcode($atts, $content='') {
	ob_start();


	if (isset($atts['site']) && $atts['site']) {
		$search_slug = $atts['site'];
		$sites = get_sites();
		for ($i = 0; $i < count($sites); $i++) {
			$domain = $sites[$i]->domain;
			$parts = explode('.', $domain);
			$slug = $parts[0];
			if ($slug == $search_slug) {
				$blog_id = $sites[$i]->blog_id;
				break;
			}
		}
		if (!$blog_id) {
			$blog_id = $sites[0]->blog_id;
		}
		switch_to_blog($blog_id);
	}
	
	?>
	<pre style="display:none;"><?php $blog_id; ?></pre>
	<section class="posts"><ul>
	<?php

	// WP_Query arguments
	$args = array (
		'post_type'              => array( 'post' ),
		'posts_per_page'         => '5',
	);

	// The Query
	$query = new WP_Query( $args );

	// The Loop
	if ( $query->have_posts() ) {
		while ( $query->have_posts() ) {
			$query->the_post();
			echo '<li><span>';
			the_date();
			// echo 'August 17, 2015';
			echo '</span>';
			echo '<a href="';
			the_permalink();
			echo '">';
			the_title();
			echo '</a></li>';
		}
	} else {
		// no posts found
	}

	// Restore original Post Data
	wp_reset_postdata();
	?>            
    </ul></section>
	<?php
	$r = ob_get_contents();
	ob_end_clean();

	if (isset($atts['site']) && $atts['site']) {
		restore_current_blog();
	}

	return $r;
}
