<?php

add_action('wp_ajax_cpm_base_configure_all', 'cpm_base_configure_all');

function cpm_base_configure_all() {
	$r = array(
		'messages' => array(),
	);

	$all_actions = array(
		'cpm_forms_rebuild_forms',
		'cpm_lightbox_rebuild_lightboxes',
		'cpm_w3tc_load_settings',
		'cpm_wordfence_load_settings',
		'cpm_base_load_acf_settings',
		'cpm_mailgun_load_settings',
		'cpm_fonts_load_settings',
		'cpm_maps_load_settings'
	);

	foreach ($all_actions as $action) {
		$status = json_decode($action());
		if (isset($status->error)) {
			$r['error'] = true;
		}
		array_push($r['messages'], $status->message);
	}

	if (!isset($r['error'])) {
		$r['success'] = true;
	}

	$r['message'] = implode('<br>', $r['messages']);
	$r['message'] = 'Configuration complete:<br>' . $r['message'];
	unset($r['messages']);
	echo json_encode($r);
	die();
}