(function($){
	
	
	function initialize_field( $el ) {
		
		//$el.doStuff();
		var $input = $el.find('.acf-input');
		var $button = $input.find('button');
		var action = $button.attr('data-action');
		var $loading = $('<div class="acf-loading"></div>');
		$button.click(function(e) {
			e.preventDefault();
			$button.after($loading);
			$.get({
				url: ajaxurl,
				data: {
					action: action
				},
				dataType: 'json',
				success: function(data) {
					$loading.remove();
					$input.find('.acf-action-message').remove();

					if (data.success == true) {
						var c = 'acf-action-message acf-action-success-message';	
					}
					else if (data.error == true) {
						var c = 'acf-action-message acf-action-error-message';
					}
					
					$input.append('<div class="' + c + '"><p>' + data.message + '</p></div>');
				}
			})
		});
		
	}
	
	
	if( typeof acf.add_action !== 'undefined' ) {
	
		/*
		*  ready append (ACF5)
		*
		*  These are 2 events which are fired during the page load
		*  ready = on page load similar to $(document).ready()
		*  append = on new DOM elements appended via repeater field
		*
		*  @type	event
		*  @date	20/07/13
		*
		*  @param	$el (jQuery selection) the jQuery element which contains the ACF fields
		*  @return	n/a
		*/
		
		acf.add_action('ready append', function( $el ){
			
			// search $el for fields of type 'FIELD_NAME'
			acf.get_fields({ type : 'action'}, $el).each(function(){
				
				initialize_field( $(this) );
				
			});
			
		});
		
		
	} else {
		
		
		/*
		*  acf/setup_fields (ACF4)
		*
		*  This event is triggered when ACF adds any new elements to the DOM. 
		*
		*  @type	function
		*  @since	1.0.0
		*  @date	01/01/12
		*
		*  @param	event		e: an event object. This can be ignored
		*  @param	Element		postbox: An element which contains the new HTML
		*
		*  @return	n/a
		*/
		
		$(document).on('acf/setup_fields', function(e, postbox){
			
			$(postbox).find('.field[data-field_type="action"]').each(function(){
				
				initialize_field( $(this) );
				
			});
		
		});
	
	
	}


})(jQuery);
