<?php
/**
 * Plugin Name: CPM
 * Plugin URI:  http://plugins.creativedentalwebsites.com/cpm
 * Description: Base/Misc Functionality
 * Version: 0.2.101
 */

define( "CPM_VERSION", "0.2.101" );

define( 'CPM_URL',     plugin_dir_url( __FILE__ ) );
define( 'CPM_PATH',    dirname( __FILE__ ) . '/' );

require 'lib/plugin-updates/plugin-update-checker.php';
$update_checker = PucFactory::buildUpdateChecker('http://plugins.creativedentalwebsites.com/cpm/cpm.json', __FILE__);

require 'vendor/autoload.php';

require 'lib/actions/allow-internal-hosts.php';

require 'lib/acf-action-field-type/acf-action.php';
require 'lib/acf-documentation-field-type/acf-documentation.php';

require 'modules/admin/index.php';
require 'modules/base/index.php';
require 'modules/blog/index.php';
require 'modules/compat/index.php';
require 'modules/datepicker/index.php';
require 'modules/export/index.php';
require 'modules/facebook/index.php';
require 'modules/foobar/index.php';
require 'modules/fonts/index.php';
require 'modules/forms/index.php';
require 'modules/images/index.php';
require 'modules/lightbox/index.php';
require 'modules/mailgun/index.php';
require 'modules/maps/index.php';
require 'modules/markup/index.php';
require 'modules/mask/index.php';
require 'modules/menus/index.php';
require 'modules/multisite/index.php';
require 'modules/optio/index.php';
require 'modules/pagelist/index.php';
require 'modules/videos/index.php';
require 'modules/w3tc/index.php';
require 'modules/wordfence/index.php';
require 'modules/widgets/index.php';

require 'lib/scripts.php';
?>
